@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleConditionHostHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values
 */
public data class ListenerRuleConditionHostHeaderArgs(
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleConditionHostHeaderArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleConditionHostHeaderArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleConditionHostHeaderArgs.builder()
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListenerRuleConditionHostHeaderArgs].
 */
@PulumiTagMarker
public class ListenerRuleConditionHostHeaderArgsBuilder internal constructor() {
    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("qbhsqsclqxschoes")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("jirnknohcefewtyb")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qolhwxvxygvafryf")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bwmtsjleyfucbyoi")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("ftrvukvakdvotayb")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ListenerRuleConditionHostHeaderArgs = ListenerRuleConditionHostHeaderArgs(
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
