@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleConditionPathPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values
 */
public data class ListenerRuleConditionPathPatternArgs(
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleConditionPathPatternArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleConditionPathPatternArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleConditionPathPatternArgs.builder()
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListenerRuleConditionPathPatternArgs].
 */
@PulumiTagMarker
public class ListenerRuleConditionPathPatternArgsBuilder internal constructor() {
    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("symkgdmyqmluvgsa")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("orkawntgrgnaiewp")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wtlfvlxvnonpqfwn")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hfqdpbssboxaspds")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("rkaptaoyrlbhjepy")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ListenerRuleConditionPathPatternArgs = ListenerRuleConditionPathPatternArgs(
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
