@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleConditionQueryStringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Query string key pattern to match.
 * @property value Query string value pattern to match.
 */
public data class ListenerRuleConditionQueryStringArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleConditionQueryStringArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleConditionQueryStringArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleConditionQueryStringArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleConditionQueryStringArgs].
 */
@PulumiTagMarker
public class ListenerRuleConditionQueryStringArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Query string key pattern to match.
     */
    @JvmName("oesuyofqeglvxdtj")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Query string value pattern to match.
     */
    @JvmName("nihjtfrpoqgwssaq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Query string key pattern to match.
     */
    @JvmName("tvgowrfknjbgogcn")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Query string value pattern to match.
     */
    @JvmName("iguqduxygtcxtlhk")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ListenerRuleConditionQueryStringArgs = ListenerRuleConditionQueryStringArgs(
        key = key,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
