@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property minimumHealthyTargetsCount The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
 * @property minimumHealthyTargetsPercentage The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
 */
public data class TargetGroupTargetGroupHealthDnsFailoverArgs(
    public val minimumHealthyTargetsCount: Output<String>? = null,
    public val minimumHealthyTargetsPercentage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs =
        com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs.builder()
            .minimumHealthyTargetsCount(minimumHealthyTargetsCount?.applyValue({ args0 -> args0 }))
            .minimumHealthyTargetsPercentage(
                minimumHealthyTargetsPercentage?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TargetGroupTargetGroupHealthDnsFailoverArgs].
 */
@PulumiTagMarker
public class TargetGroupTargetGroupHealthDnsFailoverArgsBuilder internal constructor() {
    private var minimumHealthyTargetsCount: Output<String>? = null

    private var minimumHealthyTargetsPercentage: Output<String>? = null

    /**
     * @param value The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
     */
    @JvmName("aikwkiagwnjixuix")
    public suspend fun minimumHealthyTargetsCount(`value`: Output<String>) {
        this.minimumHealthyTargetsCount = value
    }

    /**
     * @param value The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
     */
    @JvmName("slocyrilhnxwckfl")
    public suspend fun minimumHealthyTargetsPercentage(`value`: Output<String>) {
        this.minimumHealthyTargetsPercentage = value
    }

    /**
     * @param value The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
     */
    @JvmName("cirwjdhpfxeylhjv")
    public suspend fun minimumHealthyTargetsCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumHealthyTargetsCount = mapped
    }

    /**
     * @param value The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
     */
    @JvmName("wlbslkjgrrjgpdab")
    public suspend fun minimumHealthyTargetsPercentage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumHealthyTargetsPercentage = mapped
    }

    internal fun build(): TargetGroupTargetGroupHealthDnsFailoverArgs =
        TargetGroupTargetGroupHealthDnsFailoverArgs(
            minimumHealthyTargetsCount = minimumHealthyTargetsCount,
            minimumHealthyTargetsPercentage = minimumHealthyTargetsPercentage,
        )
}
