@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property minimumHealthyTargetsCount The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
 * @property minimumHealthyTargetsPercentage The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
 */
public data class TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs(
    public val minimumHealthyTargetsCount: Output<Int>? = null,
    public val minimumHealthyTargetsPercentage: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs =
        com.pulumi.aws.alb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs.builder()
            .minimumHealthyTargetsCount(minimumHealthyTargetsCount?.applyValue({ args0 -> args0 }))
            .minimumHealthyTargetsPercentage(
                minimumHealthyTargetsPercentage?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs].
 */
@PulumiTagMarker
public class TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsBuilder internal constructor() {
    private var minimumHealthyTargetsCount: Output<Int>? = null

    private var minimumHealthyTargetsPercentage: Output<String>? = null

    /**
     * @param value The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
     */
    @JvmName("pcqnrylhpnimvmwt")
    public suspend fun minimumHealthyTargetsCount(`value`: Output<Int>) {
        this.minimumHealthyTargetsCount = value
    }

    /**
     * @param value The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
     */
    @JvmName("jaricmmtjiwlvjnx")
    public suspend fun minimumHealthyTargetsPercentage(`value`: Output<String>) {
        this.minimumHealthyTargetsPercentage = value
    }

    /**
     * @param value The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
     */
    @JvmName("uourrvnbarfxwbwt")
    public suspend fun minimumHealthyTargetsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumHealthyTargetsCount = mapped
    }

    /**
     * @param value The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
     */
    @JvmName("gnsinxvaxneysqki")
    public suspend fun minimumHealthyTargetsPercentage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumHealthyTargetsPercentage = mapped
    }

    internal fun build(): TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs =
        TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs(
            minimumHealthyTargetsCount = minimumHealthyTargetsCount,
            minimumHealthyTargetsPercentage = minimumHealthyTargetsPercentage,
        )
}
