@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams
 * @property onUnauthenticatedRequest
 * @property scope
 * @property sessionCookieName
 * @property sessionTimeout
 * @property userPoolArn
 * @property userPoolClientId
 * @property userPoolDomain
 */
public data class GetListenerDefaultActionAuthenticateCognito(
    public val authenticationRequestExtraParams: Map<String, String>,
    public val onUnauthenticatedRequest: String,
    public val scope: String,
    public val sessionCookieName: String,
    public val sessionTimeout: Int,
    public val userPoolArn: String,
    public val userPoolClientId: String,
    public val userPoolDomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.GetListenerDefaultActionAuthenticateCognito): GetListenerDefaultActionAuthenticateCognito = GetListenerDefaultActionAuthenticateCognito(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            onUnauthenticatedRequest = javaType.onUnauthenticatedRequest(),
            scope = javaType.scope(),
            sessionCookieName = javaType.sessionCookieName(),
            sessionTimeout = javaType.sessionTimeout(),
            userPoolArn = javaType.userPoolArn(),
            userPoolClientId = javaType.userPoolClientId(),
            userPoolDomain = javaType.userPoolDomain(),
        )
    }
}
