@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property stickiness Configuration block for target group stickiness for the rule. Detailed below.
 * @property targetGroups Set of 1-5 target group blocks. Detailed below.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionForward(
    public val stickiness: ListenerDefaultActionForwardStickiness? = null,
    public val targetGroups: List<ListenerDefaultActionForwardTargetGroup>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.ListenerDefaultActionForward): ListenerDefaultActionForward = ListenerDefaultActionForward(
            stickiness = javaType.stickiness().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionForwardStickiness.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetGroups = javaType.targetGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionForwardTargetGroup.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
