@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticateCognito Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
 * @property authenticateOidc Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
 * @property fixedResponse Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
 * @property forward Configuration block for creating an action that distributes requests among one or more target groups.
 * Specify only if `type` is `forward`.
 * Cannot be specified with `target_group_arn`.
 * @property order Order for the action.
 * The action with the lowest value for order is performed first.
 * Valid values are between `1` and `50000`.
 * Defaults to the position in the list of actions.
 * @property redirect Information for creating a redirect action. Required if `type` is `redirect`.
 * @property targetGroupArn ARN of the Target Group to which to route traffic.
 * Specify only if `type` is `forward` and you want to route to a single target group.
 * To route to one or more target groups, use a `forward` block instead.
 * Cannot be specified with `forward`.
 * @property type The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
 */
public data class ListenerRuleAction(
    public val authenticateCognito: ListenerRuleActionAuthenticateCognito? = null,
    public val authenticateOidc: ListenerRuleActionAuthenticateOidc? = null,
    public val fixedResponse: ListenerRuleActionFixedResponse? = null,
    public val forward: ListenerRuleActionForward? = null,
    public val order: Int? = null,
    public val redirect: ListenerRuleActionRedirect? = null,
    public val targetGroupArn: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.ListenerRuleAction): ListenerRuleAction = ListenerRuleAction(
            authenticateCognito = javaType.authenticateCognito().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionAuthenticateCognito.Companion.toKotlin(args0)
                })
            }).orElse(null),
            authenticateOidc = javaType.authenticateOidc().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionAuthenticateOidc.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fixedResponse = javaType.fixedResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionFixedResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forward = javaType.forward().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionForward.Companion.toKotlin(args0)
                })
            }).orElse(null),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            redirect = javaType.redirect().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionRedirect.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetGroupArn = javaType.targetGroupArn().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
