@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contentType The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
 * @property messageBody The message body.
 * @property statusCode The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
 */
public data class ListenerRuleActionFixedResponse(
    public val contentType: String,
    public val messageBody: String? = null,
    public val statusCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.ListenerRuleActionFixedResponse): ListenerRuleActionFixedResponse = ListenerRuleActionFixedResponse(
            contentType = javaType.contentType(),
            messageBody = javaType.messageBody().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
