@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property stickiness The target group stickiness for the rule.
 * @property targetGroups One or more target groups block.
 */
public data class ListenerRuleActionForward(
    public val stickiness: ListenerRuleActionForwardStickiness? = null,
    public val targetGroups: List<ListenerRuleActionForwardTargetGroup>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.ListenerRuleActionForward): ListenerRuleActionForward = ListenerRuleActionForward(
            stickiness = javaType.stickiness().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionForwardStickiness.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetGroups = javaType.targetGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerRuleActionForwardTargetGroup.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
