@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property duration The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
 * @property enabled Indicates whether target group stickiness is enabled.
 */
public data class ListenerRuleActionForwardStickiness(
    public val duration: Int,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.ListenerRuleActionForwardStickiness): ListenerRuleActionForwardStickiness = ListenerRuleActionForwardStickiness(
            duration = javaType.duration(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
