@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket S3 bucket name to store the logs in.
 * @property enabled Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
 * @property prefix S3 bucket prefix. Logs are stored in the root if not configured.
 */
public data class LoadBalancerConnectionLogs(
    public val bucket: String,
    public val enabled: Boolean? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.LoadBalancerConnectionLogs): LoadBalancerConnectionLogs = LoadBalancerConnectionLogs(
            bucket = javaType.bucket(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
