@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property onDeregistration Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
 * @property onUnhealthy Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
 */
public data class TargetGroupTargetFailover(
    public val onDeregistration: String,
    public val onUnhealthy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.TargetGroupTargetFailover): TargetGroupTargetFailover = TargetGroupTargetFailover(
            onDeregistration = javaType.onDeregistration(),
            onUnhealthy = javaType.onUnhealthy(),
        )
    }
}
