@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property dnsFailover Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
 * @property unhealthyStateRouting Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
 */
public data class TargetGroupTargetGroupHealth(
    public val dnsFailover: TargetGroupTargetGroupHealthDnsFailover? = null,
    public val unhealthyStateRouting: TargetGroupTargetGroupHealthUnhealthyStateRouting? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.TargetGroupTargetGroupHealth): TargetGroupTargetGroupHealth = TargetGroupTargetGroupHealth(
            dnsFailover = javaType.dnsFailover().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.TargetGroupTargetGroupHealthDnsFailover.Companion.toKotlin(args0)
                })
            }).orElse(null),
            unhealthyStateRouting = javaType.unhealthyStateRouting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.TargetGroupTargetGroupHealthUnhealthyStateRouting.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
