@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property enableUnhealthyConnectionTermination Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
 * @property unhealthyDrainingInterval Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
 */
public data class TargetGroupTargetHealthState(
    public val enableUnhealthyConnectionTermination: Boolean,
    public val unhealthyDrainingInterval: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.TargetGroupTargetHealthState): TargetGroupTargetHealthState = TargetGroupTargetHealthState(
            enableUnhealthyConnectionTermination = javaType.enableUnhealthyConnectionTermination(),
            unhealthyDrainingInterval = javaType.unhealthyDrainingInterval().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
