@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.AlertManagerDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Alert Manager Definition
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const demo = new aws.amp.Workspace("demo", {});
 * const demoAlertManagerDefinition = new aws.amp.AlertManagerDefinition("demo", {
 *     workspaceId: demo.id,
 *     definition: `alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * demo = aws.amp.Workspace("demo")
 * demo_alert_manager_definition = aws.amp.AlertManagerDefinition("demo",
 *     workspace_id=demo.id,
 *     definition="""alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var demo = new Aws.Amp.Workspace("demo");
 *     var demoAlertManagerDefinition = new Aws.Amp.AlertManagerDefinition("demo", new()
 *     {
 *         WorkspaceId = demo.Id,
 *         Definition = @"alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		demo, err := amp.NewWorkspace(ctx, "demo", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewAlertManagerDefinition(ctx, "demo", &amp.AlertManagerDefinitionArgs{
 * 			WorkspaceId: demo.ID(),
 * 			Definition: pulumi.String(`alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.AlertManagerDefinition;
 * import com.pulumi.aws.amp.AlertManagerDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demo = new Workspace("demo");
 *         var demoAlertManagerDefinition = new AlertManagerDefinition("demoAlertManagerDefinition", AlertManagerDefinitionArgs.builder()
 *             .workspaceId(demo.id())
 *             .definition("""
 * alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   demo:
 *     type: aws:amp:Workspace
 *   demoAlertManagerDefinition:
 *     type: aws:amp:AlertManagerDefinition
 *     name: demo
 *     properties:
 *       workspaceId: ${demo.id}
 *       definition: |
 *         alertmanager_config: |
 *           route:
 *             receiver: 'default'
 *           receivers:
 *             - name: 'default'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the prometheus alert manager definition using the workspace identifier. For example:
 * ```sh
 * $ pulumi import aws:amp/alertManagerDefinition:AlertManagerDefinition demo ws-C6DCB907-F2D7-4D96-957B-66691F865D8B
 * ```
 * @property definition the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
 * @property workspaceId ID of the prometheus workspace the alert manager definition should be linked to
 */
public data class AlertManagerDefinitionArgs(
    public val definition: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.AlertManagerDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.amp.AlertManagerDefinitionArgs =
        com.pulumi.aws.amp.AlertManagerDefinitionArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertManagerDefinitionArgs].
 */
@PulumiTagMarker
public class AlertManagerDefinitionArgsBuilder internal constructor() {
    private var definition: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     */
    @JvmName("bfvemwysocdetsjf")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value ID of the prometheus workspace the alert manager definition should be linked to
     */
    @JvmName("tbnshpstxwwqnbbl")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     */
    @JvmName("gkdxkiphrwcxefob")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value ID of the prometheus workspace the alert manager definition should be linked to
     */
    @JvmName("iduartvhyrdbtddy")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): AlertManagerDefinitionArgs = AlertManagerDefinitionArgs(
        definition = definition,
        workspaceId = workspaceId,
    )
}
