@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RuleGroupNamespace].
 */
@PulumiTagMarker
public class RuleGroupNamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleGroupNamespaceArgs = RuleGroupNamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleGroupNamespaceArgsBuilder.() -> Unit) {
        val builder = RuleGroupNamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RuleGroupNamespace {
        val builtJavaResource = com.pulumi.aws.amp.RuleGroupNamespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuleGroupNamespace(builtJavaResource)
    }
}

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Rule Group Namespace
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const demo = new aws.amp.Workspace("demo", {});
 * const demoRuleGroupNamespace = new aws.amp.RuleGroupNamespace("demo", {
 *     name: "rules",
 *     workspaceId: demo.id,
 *     data: `groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * demo = aws.amp.Workspace("demo")
 * demo_rule_group_namespace = aws.amp.RuleGroupNamespace("demo",
 *     name="rules",
 *     workspace_id=demo.id,
 *     data="""groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var demo = new Aws.Amp.Workspace("demo");
 *     var demoRuleGroupNamespace = new Aws.Amp.RuleGroupNamespace("demo", new()
 *     {
 *         Name = "rules",
 *         WorkspaceId = demo.Id,
 *         Data = @"groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		demo, err := amp.NewWorkspace(ctx, "demo", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewRuleGroupNamespace(ctx, "demo", &amp.RuleGroupNamespaceArgs{
 * 			Name:        pulumi.String("rules"),
 * 			WorkspaceId: demo.ID(),
 * 			Data: pulumi.String(`groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.RuleGroupNamespace;
 * import com.pulumi.aws.amp.RuleGroupNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demo = new Workspace("demo");
 *         var demoRuleGroupNamespace = new RuleGroupNamespace("demoRuleGroupNamespace", RuleGroupNamespaceArgs.builder()
 *             .name("rules")
 *             .workspaceId(demo.id())
 *             .data("""
 * groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   demo:
 *     type: aws:amp:Workspace
 *   demoRuleGroupNamespace:
 *     type: aws:amp:RuleGroupNamespace
 *     name: demo
 *     properties:
 *       name: rules
 *       workspaceId: ${demo.id}
 *       data: |
 *         groups:
 *           - name: test
 *             rules:
 *             - record: metric:recording_rule
 *               expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the prometheus rule group namespace using the arn. For example:
 * ```sh
 * $ pulumi import aws:amp/ruleGroupNamespace:RuleGroupNamespace demo arn:aws:aps:us-west-2:123456789012:rulegroupsnamespace/IDstring/namespace_name
 * ```
 */
public class RuleGroupNamespace internal constructor(
    override val javaResource: com.pulumi.aws.amp.RuleGroupNamespace,
) : KotlinCustomResource(javaResource, RuleGroupNamespaceMapper) {
    /**
     * the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
     */
    public val `data`: Output<String>
        get() = javaResource.`data`().applyValue({ args0 -> args0 })

    /**
     * The name of the rule group namespace
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the prometheus workspace the rule group namespace should be linked to
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object RuleGroupNamespaceMapper : ResourceMapper<RuleGroupNamespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amp.RuleGroupNamespace::class == javaResource::class

    override fun map(javaResource: Resource): RuleGroupNamespace = RuleGroupNamespace(
        javaResource as
            com.pulumi.aws.amp.RuleGroupNamespace,
    )
}

/**
 * @see [RuleGroupNamespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuleGroupNamespace].
 */
public suspend fun ruleGroupNamespace(
    name: String,
    block: suspend RuleGroupNamespaceResourceBuilder.() -> Unit,
): RuleGroupNamespace {
    val builder = RuleGroupNamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuleGroupNamespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ruleGroupNamespace(name: String): RuleGroupNamespace {
    val builder = RuleGroupNamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
