@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.RuleGroupNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Rule Group Namespace
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const demo = new aws.amp.Workspace("demo", {});
 * const demoRuleGroupNamespace = new aws.amp.RuleGroupNamespace("demo", {
 *     name: "rules",
 *     workspaceId: demo.id,
 *     data: `groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * demo = aws.amp.Workspace("demo")
 * demo_rule_group_namespace = aws.amp.RuleGroupNamespace("demo",
 *     name="rules",
 *     workspace_id=demo.id,
 *     data="""groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var demo = new Aws.Amp.Workspace("demo");
 *     var demoRuleGroupNamespace = new Aws.Amp.RuleGroupNamespace("demo", new()
 *     {
 *         Name = "rules",
 *         WorkspaceId = demo.Id,
 *         Data = @"groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		demo, err := amp.NewWorkspace(ctx, "demo", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewRuleGroupNamespace(ctx, "demo", &amp.RuleGroupNamespaceArgs{
 * 			Name:        pulumi.String("rules"),
 * 			WorkspaceId: demo.ID(),
 * 			Data: pulumi.String(`groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.RuleGroupNamespace;
 * import com.pulumi.aws.amp.RuleGroupNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demo = new Workspace("demo");
 *         var demoRuleGroupNamespace = new RuleGroupNamespace("demoRuleGroupNamespace", RuleGroupNamespaceArgs.builder()
 *             .name("rules")
 *             .workspaceId(demo.id())
 *             .data("""
 * groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   demo:
 *     type: aws:amp:Workspace
 *   demoRuleGroupNamespace:
 *     type: aws:amp:RuleGroupNamespace
 *     name: demo
 *     properties:
 *       name: rules
 *       workspaceId: ${demo.id}
 *       data: |
 *         groups:
 *           - name: test
 *             rules:
 *             - record: metric:recording_rule
 *               expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the prometheus rule group namespace using the arn. For example:
 * ```sh
 * $ pulumi import aws:amp/ruleGroupNamespace:RuleGroupNamespace demo arn:aws:aps:us-west-2:123456789012:rulegroupsnamespace/IDstring/namespace_name
 * ```
 * @property data the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
 * @property name The name of the rule group namespace
 * @property workspaceId ID of the prometheus workspace the rule group namespace should be linked to
 */
public data class RuleGroupNamespaceArgs(
    public val `data`: Output<String>? = null,
    public val name: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.RuleGroupNamespaceArgs> {
    override fun toJava(): com.pulumi.aws.amp.RuleGroupNamespaceArgs =
        com.pulumi.aws.amp.RuleGroupNamespaceArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupNamespaceArgs].
 */
@PulumiTagMarker
public class RuleGroupNamespaceArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var name: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
     */
    @JvmName("swbxkpfoiyeadugo")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value The name of the rule group namespace
     */
    @JvmName("rhgiwmfnddmckcay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the prometheus workspace the rule group namespace should be linked to
     */
    @JvmName("unpvmrhtjbrlwvti")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
     */
    @JvmName("gtucrmiffsttufmb")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value The name of the rule group namespace
     */
    @JvmName("atsnsdeymwfmkwur")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the prometheus workspace the rule group namespace should be linked to
     */
    @JvmName("akyjopbfrxsogkle")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): RuleGroupNamespaceArgs = RuleGroupNamespaceArgs(
        `data` = `data`,
        name = name,
        workspaceId = workspaceId,
    )
}
