@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.kotlin.outputs.ScraperDestination
import com.pulumi.aws.amp.kotlin.outputs.ScraperSource
import com.pulumi.aws.amp.kotlin.outputs.ScraperTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.amp.kotlin.outputs.ScraperDestination.Companion.toKotlin as scraperDestinationToKotlin
import com.pulumi.aws.amp.kotlin.outputs.ScraperSource.Companion.toKotlin as scraperSourceToKotlin
import com.pulumi.aws.amp.kotlin.outputs.ScraperTimeouts.Companion.toKotlin as scraperTimeoutsToKotlin

/**
 * Builder for [Scraper].
 */
@PulumiTagMarker
public class ScraperResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScraperArgs = ScraperArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScraperArgsBuilder.() -> Unit) {
        val builder = ScraperArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Scraper {
        val builtJavaResource = com.pulumi.aws.amp.Scraper(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Scraper(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Using `pulumi import`, import the Managed Scraper using its identifier.
 * For example:
 * ```sh
 * $ pulumi import aws:amp/scraper:Scraper example s-0123abc-0000-0123-a000-000000000000
 * ```
 */
public class Scraper internal constructor(
    override val javaResource: com.pulumi.aws.amp.Scraper,
) : KotlinCustomResource(javaResource, ScraperMapper) {
    /**
     * a name to associate with the managed scraper. This is for your use, and does not need to be unique.
     */
    public val alias: Output<String>?
        get() = javaResource.alias().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Amazon Resource Name (ARN) of the new scraper.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the managed scraper to send metrics to. See `destination`.
     */
    public val destination: Output<ScraperDestination>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scraperDestinationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover, collect, and produce metrics
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
     */
    public val scrapeConfiguration: Output<String>
        get() = javaResource.scrapeConfiguration().applyValue({ args0 -> args0 })

    /**
     * Configuration block to specify where the managed scraper will collect metrics from. See `source`.
     * The following arguments are optional:
     */
    public val source: Output<ScraperSource>?
        get() = javaResource.source().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scraperSourceToKotlin(args0)
                })
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ScraperTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scraperTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ScraperMapper : ResourceMapper<Scraper> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amp.Scraper::class == javaResource::class

    override fun map(javaResource: Resource): Scraper = Scraper(
        javaResource as
            com.pulumi.aws.amp.Scraper,
    )
}

/**
 * @see [Scraper].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Scraper].
 */
public suspend fun scraper(name: String, block: suspend ScraperResourceBuilder.() -> Unit): Scraper {
    val builder = ScraperResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Scraper].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scraper(name: String): Scraper {
    val builder = ScraperResourceBuilder()
    builder.name(name)
    return builder.build()
}
