@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.ScraperArgs.builder
import com.pulumi.aws.amp.kotlin.inputs.ScraperDestinationArgs
import com.pulumi.aws.amp.kotlin.inputs.ScraperDestinationArgsBuilder
import com.pulumi.aws.amp.kotlin.inputs.ScraperSourceArgs
import com.pulumi.aws.amp.kotlin.inputs.ScraperSourceArgsBuilder
import com.pulumi.aws.amp.kotlin.inputs.ScraperTimeoutsArgs
import com.pulumi.aws.amp.kotlin.inputs.ScraperTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Using `pulumi import`, import the Managed Scraper using its identifier.
 * For example:
 * ```sh
 * $ pulumi import aws:amp/scraper:Scraper example s-0123abc-0000-0123-a000-000000000000
 * ```
 * @property alias a name to associate with the managed scraper. This is for your use, and does not need to be unique.
 * @property destination Configuration block for the managed scraper to send metrics to. See `destination`.
 * @property scrapeConfiguration The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
 * @property source Configuration block to specify where the managed scraper will collect metrics from. See `source`.
 * The following arguments are optional:
 * @property tags
 * @property timeouts
 */
public data class ScraperArgs(
    public val alias: Output<String>? = null,
    public val destination: Output<ScraperDestinationArgs>? = null,
    public val scrapeConfiguration: Output<String>? = null,
    public val source: Output<ScraperSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ScraperTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.ScraperArgs> {
    override fun toJava(): com.pulumi.aws.amp.ScraperArgs = com.pulumi.aws.amp.ScraperArgs.builder()
        .alias(alias?.applyValue({ args0 -> args0 }))
        .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .scrapeConfiguration(scrapeConfiguration?.applyValue({ args0 -> args0 }))
        .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScraperArgs].
 */
@PulumiTagMarker
public class ScraperArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var destination: Output<ScraperDestinationArgs>? = null

    private var scrapeConfiguration: Output<String>? = null

    private var source: Output<ScraperSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ScraperTimeoutsArgs>? = null

    /**
     * @param value a name to associate with the managed scraper. This is for your use, and does not need to be unique.
     */
    @JvmName("fpxshntjpqwujbkb")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Configuration block for the managed scraper to send metrics to. See `destination`.
     */
    @JvmName("wltjdcolbokugsrm")
    public suspend fun destination(`value`: Output<ScraperDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
     */
    @JvmName("yoadoeinmphugbhh")
    public suspend fun scrapeConfiguration(`value`: Output<String>) {
        this.scrapeConfiguration = value
    }

    /**
     * @param value Configuration block to specify where the managed scraper will collect metrics from. See `source`.
     * The following arguments are optional:
     */
    @JvmName("epijpiohodbfrpfr")
    public suspend fun source(`value`: Output<ScraperSourceArgs>) {
        this.source = value
    }

    /**
     * @param value
     */
    @JvmName("npihkqcmrjvncelb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("jtolmjxndcccqwwq")
    public suspend fun timeouts(`value`: Output<ScraperTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value a name to associate with the managed scraper. This is for your use, and does not need to be unique.
     */
    @JvmName("wlktbdcnteoopqvg")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Configuration block for the managed scraper to send metrics to. See `destination`.
     */
    @JvmName("grylmqrnbrmhqyou")
    public suspend fun destination(`value`: ScraperDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Configuration block for the managed scraper to send metrics to. See `destination`.
     */
    @JvmName("kmgimoqugaphojka")
    public suspend fun destination(argument: suspend ScraperDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ScraperDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration).
     */
    @JvmName("owtvmgoxibfsjxgg")
    public suspend fun scrapeConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scrapeConfiguration = mapped
    }

    /**
     * @param value Configuration block to specify where the managed scraper will collect metrics from. See `source`.
     * The following arguments are optional:
     */
    @JvmName("xtcuwivqablrskcu")
    public suspend fun source(`value`: ScraperSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Configuration block to specify where the managed scraper will collect metrics from. See `source`.
     * The following arguments are optional:
     */
    @JvmName("gmjsvcpcptttxinf")
    public suspend fun source(argument: suspend ScraperSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ScraperSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value
     */
    @JvmName("muyhbbmycxycsiso")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("ogjaxraotymtctxk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("ayialjnnryphyycb")
    public suspend fun timeouts(`value`: ScraperTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qhtaaqlueopghjsh")
    public suspend fun timeouts(argument: suspend ScraperTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ScraperTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ScraperArgs = ScraperArgs(
        alias = alias,
        destination = destination,
        scrapeConfiguration = scrapeConfiguration,
        source = source,
        tags = tags,
        timeouts = timeouts,
    )
}
