@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.kotlin.outputs.WorkspaceLoggingConfiguration
import com.pulumi.aws.amp.kotlin.outputs.WorkspaceLoggingConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource = com.pulumi.aws.amp.Workspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workspace(builtJavaResource)
    }
}

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Workspace.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amp.Workspace("example", {
 *     alias: "example",
 *     tags: {
 *         Environment: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amp.Workspace("example",
 *     alias="example",
 *     tags={
 *         "Environment": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amp.Workspace("example", new()
 *     {
 *         Alias = "example",
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amp.NewWorkspace(ctx, "example", &amp.WorkspaceArgs{
 * 			Alias: pulumi.String("example"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .alias("example")
 *             .tags(Map.of("Environment", "production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amp:Workspace
 *     properties:
 *       alias: example
 *       tags:
 *         Environment: production
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CloudWatch Logging
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.LogGroup("example", {name: "example"});
 * const exampleWorkspace = new aws.amp.Workspace("example", {loggingConfiguration: {
 *     logGroupArn: pulumi.interpolate`${example.arn}:*`,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.LogGroup("example", name="example")
 * example_workspace = aws.amp.Workspace("example", logging_configuration={
 *     "log_group_arn": example.arn.apply(lambda arn: f"{arn}:*"),
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleWorkspace = new Aws.Amp.Workspace("example", new()
 *     {
 *         LoggingConfiguration = new Aws.Amp.Inputs.WorkspaceLoggingConfigurationArgs
 *         {
 *             LogGroupArn = example.Arn.Apply(arn => $"{arn}:*"),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewWorkspace(ctx, "example", &amp.WorkspaceArgs{
 * 			LoggingConfiguration: &amp.WorkspaceLoggingConfigurationArgs{
 * 				LogGroupArn: example.Arn.ApplyT(func(arn string) (string, error) {
 * 					return fmt.Sprintf("%v:*", arn), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.WorkspaceArgs;
 * import com.pulumi.aws.amp.inputs.WorkspaceLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LogGroup("example", LogGroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .loggingConfiguration(WorkspaceLoggingConfigurationArgs.builder()
 *                 .logGroupArn(example.arn().applyValue(arn -> String.format("%s:*", arn)))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: example
 *   exampleWorkspace:
 *     type: aws:amp:Workspace
 *     name: example
 *     properties:
 *       loggingConfiguration:
 *         logGroupArn: ${example.arn}:*
 * ```
 * <!--End PulumiCodeChooser -->
 * ### AWS KMS Customer Managed Keys (CMK)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleKey = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 7,
 * });
 * const example = new aws.amp.Workspace("example", {
 *     alias: "example",
 *     kmsKeyArn: exampleKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_key = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=7)
 * example = aws.amp.Workspace("example",
 *     alias="example",
 *     kms_key_arn=example_key.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 7,
 *     });
 *     var example = new Aws.Amp.Workspace("example", new()
 *     {
 *         Alias = "example",
 *         KmsKeyArn = exampleKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewWorkspace(ctx, "example", &amp.WorkspaceArgs{
 * 			Alias:     pulumi.String("example"),
 * 			KmsKeyArn: exampleKey.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .alias("example")
 *             .kmsKeyArn(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amp:Workspace
 *     properties:
 *       alias: example
 *       kmsKeyArn: ${exampleKey.arn}
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AMP Workspaces using the identifier. For example:
 * ```sh
 * $ pulumi import aws:amp/workspace:Workspace demo ws-C6DCB907-F2D7-4D96-957B-66691F865D8B
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.aws.amp.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The alias of the prometheus workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-onboard-create-workspace.html).
     */
    public val alias: Output<String>?
        get() = javaResource.alias().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amazon Resource Name (ARN) of the workspace.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key. If this argument is not provided, then the AWS owned encryption key will be used to encrypt the data in the workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html)
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Logging configuration for the workspace. See Logging Configuration below for details.
     */
    public val loggingConfiguration: Output<WorkspaceLoggingConfiguration>?
        get() = javaResource.loggingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Prometheus endpoint available for this workspace.
     */
    public val prometheusEndpoint: Output<String>
        get() = javaResource.prometheusEndpoint().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amp.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.aws.amp.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
