@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.WorkspaceArgs.builder
import com.pulumi.aws.amp.kotlin.inputs.WorkspaceLoggingConfigurationArgs
import com.pulumi.aws.amp.kotlin.inputs.WorkspaceLoggingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Workspace.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amp.Workspace("example", {
 *     alias: "example",
 *     tags: {
 *         Environment: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amp.Workspace("example",
 *     alias="example",
 *     tags={
 *         "Environment": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amp.Workspace("example", new()
 *     {
 *         Alias = "example",
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amp.NewWorkspace(ctx, "example", &amp.WorkspaceArgs{
 * 			Alias: pulumi.String("example"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .alias("example")
 *             .tags(Map.of("Environment", "production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amp:Workspace
 *     properties:
 *       alias: example
 *       tags:
 *         Environment: production
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CloudWatch Logging
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.LogGroup("example", {name: "example"});
 * const exampleWorkspace = new aws.amp.Workspace("example", {loggingConfiguration: {
 *     logGroupArn: pulumi.interpolate`${example.arn}:*`,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.LogGroup("example", name="example")
 * example_workspace = aws.amp.Workspace("example", logging_configuration={
 *     "log_group_arn": example.arn.apply(lambda arn: f"{arn}:*"),
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleWorkspace = new Aws.Amp.Workspace("example", new()
 *     {
 *         LoggingConfiguration = new Aws.Amp.Inputs.WorkspaceLoggingConfigurationArgs
 *         {
 *             LogGroupArn = example.Arn.Apply(arn => $"{arn}:*"),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewWorkspace(ctx, "example", &amp.WorkspaceArgs{
 * 			LoggingConfiguration: &amp.WorkspaceLoggingConfigurationArgs{
 * 				LogGroupArn: example.Arn.ApplyT(func(arn string) (string, error) {
 * 					return fmt.Sprintf("%v:*", arn), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.WorkspaceArgs;
 * import com.pulumi.aws.amp.inputs.WorkspaceLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LogGroup("example", LogGroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleWorkspace = new Workspace("exampleWorkspace", WorkspaceArgs.builder()
 *             .loggingConfiguration(WorkspaceLoggingConfigurationArgs.builder()
 *                 .logGroupArn(example.arn().applyValue(arn -> String.format("%s:*", arn)))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: example
 *   exampleWorkspace:
 *     type: aws:amp:Workspace
 *     name: example
 *     properties:
 *       loggingConfiguration:
 *         logGroupArn: ${example.arn}:*
 * ```
 * <!--End PulumiCodeChooser -->
 * ### AWS KMS Customer Managed Keys (CMK)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleKey = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 7,
 * });
 * const example = new aws.amp.Workspace("example", {
 *     alias: "example",
 *     kmsKeyArn: exampleKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_key = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=7)
 * example = aws.amp.Workspace("example",
 *     alias="example",
 *     kms_key_arn=example_key.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 7,
 *     });
 *     var example = new Aws.Amp.Workspace("example", new()
 *     {
 *         Alias = "example",
 *         KmsKeyArn = exampleKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amp"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amp.NewWorkspace(ctx, "example", &amp.WorkspaceArgs{
 * 			Alias:     pulumi.String("example"),
 * 			KmsKeyArn: exampleKey.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .alias("example")
 *             .kmsKeyArn(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amp:Workspace
 *     properties:
 *       alias: example
 *       kmsKeyArn: ${exampleKey.arn}
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: example
 *       deletionWindowInDays: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AMP Workspaces using the identifier. For example:
 * ```sh
 * $ pulumi import aws:amp/workspace:Workspace demo ws-C6DCB907-F2D7-4D96-957B-66691F865D8B
 * ```
 * @property alias The alias of the prometheus workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-onboard-create-workspace.html).
 * @property kmsKeyArn The ARN for the KMS encryption key. If this argument is not provided, then the AWS owned encryption key will be used to encrypt the data in the workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html)
 * @property loggingConfiguration Logging configuration for the workspace. See Logging Configuration below for details.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkspaceArgs(
    public val alias: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val loggingConfiguration: Output<WorkspaceLoggingConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.WorkspaceArgs> {
    override fun toJava(): com.pulumi.aws.amp.WorkspaceArgs =
        com.pulumi.aws.amp.WorkspaceArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .loggingConfiguration(
                loggingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var loggingConfiguration: Output<WorkspaceLoggingConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The alias of the prometheus workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-onboard-create-workspace.html).
     */
    @JvmName("chuwqgoftnabbgty")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The ARN for the KMS encryption key. If this argument is not provided, then the AWS owned encryption key will be used to encrypt the data in the workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html)
     */
    @JvmName("thvasflacgrvpijn")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Logging configuration for the workspace. See Logging Configuration below for details.
     */
    @JvmName("ebidefnpmvsrxdxm")
    public suspend fun loggingConfiguration(`value`: Output<WorkspaceLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yyaqrxjlpwrbxvim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The alias of the prometheus workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-onboard-create-workspace.html).
     */
    @JvmName("jdgopbfcbondwqdo")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. If this argument is not provided, then the AWS owned encryption key will be used to encrypt the data in the workspace. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html)
     */
    @JvmName("ceqrlxffuxoqxmaa")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Logging configuration for the workspace. See Logging Configuration below for details.
     */
    @JvmName("eqetdfkybunehkce")
    public suspend fun loggingConfiguration(`value`: WorkspaceLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument Logging configuration for the workspace. See Logging Configuration below for details.
     */
    @JvmName("didhtucayoldftig")
    public suspend fun loggingConfiguration(argument: suspend WorkspaceLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceLoggingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ykcagmbsyvwwokml")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bafkoyrryhsfaxcr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        alias = alias,
        kmsKeyArn = kmsKeyArn,
        loggingConfiguration = loggingConfiguration,
        tags = tags,
    )
}
