@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.inputs

import com.pulumi.aws.amp.inputs.ScraperDestinationAmpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property workspaceArn The Amazon Resource Name (ARN) of the prometheus workspace.
 */
public data class ScraperDestinationAmpArgs(
    public val workspaceArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.amp.inputs.ScraperDestinationAmpArgs> {
    override fun toJava(): com.pulumi.aws.amp.inputs.ScraperDestinationAmpArgs =
        com.pulumi.aws.amp.inputs.ScraperDestinationAmpArgs.builder()
            .workspaceArn(workspaceArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScraperDestinationAmpArgs].
 */
@PulumiTagMarker
public class ScraperDestinationAmpArgsBuilder internal constructor() {
    private var workspaceArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the prometheus workspace.
     */
    @JvmName("qamvsxtlilebcrlv")
    public suspend fun workspaceArn(`value`: Output<String>) {
        this.workspaceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the prometheus workspace.
     */
    @JvmName("tirluyivrwnrgrcl")
    public suspend fun workspaceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceArn = mapped
    }

    internal fun build(): ScraperDestinationAmpArgs = ScraperDestinationAmpArgs(
        workspaceArn = workspaceArn ?: throw PulumiNullFieldException("workspaceArn"),
    )
}
