@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.inputs

import com.pulumi.aws.amp.inputs.ScraperDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amp Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
 */
public data class ScraperDestinationArgs(
    public val amp: Output<ScraperDestinationAmpArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.inputs.ScraperDestinationArgs> {
    override fun toJava(): com.pulumi.aws.amp.inputs.ScraperDestinationArgs =
        com.pulumi.aws.amp.inputs.ScraperDestinationArgs.builder()
            .amp(amp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScraperDestinationArgs].
 */
@PulumiTagMarker
public class ScraperDestinationArgsBuilder internal constructor() {
    private var amp: Output<ScraperDestinationAmpArgs>? = null

    /**
     * @param value Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
     */
    @JvmName("mstncnqupeombavt")
    public suspend fun amp(`value`: Output<ScraperDestinationAmpArgs>) {
        this.amp = value
    }

    /**
     * @param value Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
     */
    @JvmName("uyhsknegqscofacq")
    public suspend fun amp(`value`: ScraperDestinationAmpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amp = mapped
    }

    /**
     * @param argument Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
     */
    @JvmName("qdlagkdippdsggkq")
    public suspend fun amp(argument: suspend ScraperDestinationAmpArgsBuilder.() -> Unit) {
        val toBeMapped = ScraperDestinationAmpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.amp = mapped
    }

    internal fun build(): ScraperDestinationArgs = ScraperDestinationArgs(
        amp = amp,
    )
}
