@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.inputs

import com.pulumi.aws.amp.inputs.ScraperSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property eks Configuration block for an EKS cluster source. See `eks`.
 */
public data class ScraperSourceArgs(
    public val eks: Output<ScraperSourceEksArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.inputs.ScraperSourceArgs> {
    override fun toJava(): com.pulumi.aws.amp.inputs.ScraperSourceArgs =
        com.pulumi.aws.amp.inputs.ScraperSourceArgs.builder()
            .eks(eks?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScraperSourceArgs].
 */
@PulumiTagMarker
public class ScraperSourceArgsBuilder internal constructor() {
    private var eks: Output<ScraperSourceEksArgs>? = null

    /**
     * @param value Configuration block for an EKS cluster source. See `eks`.
     */
    @JvmName("wurnyihxfdcmfleo")
    public suspend fun eks(`value`: Output<ScraperSourceEksArgs>) {
        this.eks = value
    }

    /**
     * @param value Configuration block for an EKS cluster source. See `eks`.
     */
    @JvmName("qkpjkhhkkosggxhk")
    public suspend fun eks(`value`: ScraperSourceEksArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eks = mapped
    }

    /**
     * @param argument Configuration block for an EKS cluster source. See `eks`.
     */
    @JvmName("dcosrigvafukuurx")
    public suspend fun eks(argument: suspend ScraperSourceEksArgsBuilder.() -> Unit) {
        val toBeMapped = ScraperSourceEksArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eks = mapped
    }

    internal fun build(): ScraperSourceArgs = ScraperSourceArgs(
        eks = eks,
    )
}
