@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.inputs

import com.pulumi.aws.amp.inputs.ScraperSourceEksArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clusterArn
 * @property securityGroupIds List of the security group IDs for the Amazon EKS cluster VPC configuration.
 * @property subnetIds List of subnet IDs. Must be in at least two different availability zones.
 */
public data class ScraperSourceEksArgs(
    public val clusterArn: Output<String>,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.amp.inputs.ScraperSourceEksArgs> {
    override fun toJava(): com.pulumi.aws.amp.inputs.ScraperSourceEksArgs =
        com.pulumi.aws.amp.inputs.ScraperSourceEksArgs.builder()
            .clusterArn(clusterArn.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScraperSourceEksArgs].
 */
@PulumiTagMarker
public class ScraperSourceEksArgsBuilder internal constructor() {
    private var clusterArn: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("oxeatfmmtwkrwrre")
    public suspend fun clusterArn(`value`: Output<String>) {
        this.clusterArn = value
    }

    /**
     * @param value List of the security group IDs for the Amazon EKS cluster VPC configuration.
     */
    @JvmName("uctdgkqsgehdkiik")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("twpkxmndxrqecksv")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of the security group IDs for the Amazon EKS cluster VPC configuration.
     */
    @JvmName("jjcbcguhpvypxdeb")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of subnet IDs. Must be in at least two different availability zones.
     */
    @JvmName("diclknfvkyrvjpgt")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ciitbymboblnudtb")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of subnet IDs. Must be in at least two different availability zones.
     */
    @JvmName("vdwdsllclslfgrbx")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ynrjpbfnfddrbmom")
    public suspend fun clusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterArn = mapped
    }

    /**
     * @param value List of the security group IDs for the Amazon EKS cluster VPC configuration.
     */
    @JvmName("apjbxjwlhktmydgv")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of the security group IDs for the Amazon EKS cluster VPC configuration.
     */
    @JvmName("svroyjdtaqkfqwti")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of subnet IDs. Must be in at least two different availability zones.
     */
    @JvmName("webuficuqobwgngs")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of subnet IDs. Must be in at least two different availability zones.
     */
    @JvmName("avjthjvnuoyervww")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ScraperSourceEksArgs = ScraperSourceEksArgs(
        clusterArn = clusterArn ?: throw PulumiNullFieldException("clusterArn"),
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
