@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.inputs

import com.pulumi.aws.amp.inputs.WorkspaceLoggingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupArn The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
 */
public data class WorkspaceLoggingConfigurationArgs(
    public val logGroupArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.amp.inputs.WorkspaceLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.amp.inputs.WorkspaceLoggingConfigurationArgs =
        com.pulumi.aws.amp.inputs.WorkspaceLoggingConfigurationArgs.builder()
            .logGroupArn(logGroupArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class WorkspaceLoggingConfigurationArgsBuilder internal constructor() {
    private var logGroupArn: Output<String>? = null

    /**
     * @param value The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
     */
    @JvmName("tnomrdmyffppqxcg")
    public suspend fun logGroupArn(`value`: Output<String>) {
        this.logGroupArn = value
    }

    /**
     * @param value The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
     */
    @JvmName("vmfvmsfwdotxaatk")
    public suspend fun logGroupArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupArn = mapped
    }

    internal fun build(): WorkspaceLoggingConfigurationArgs = WorkspaceLoggingConfigurationArgs(
        logGroupArn = logGroupArn ?: throw PulumiNullFieldException("logGroupArn"),
    )
}
