@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getWorkspaces.
 * @property aliasPrefix
 * @property aliases List of aliases of the matched Prometheus workspaces.
 * @property arns List of ARNs of the matched Prometheus workspaces.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property workspaceIds List of workspace IDs of the matched Prometheus workspaces.
 */
public data class GetWorkspacesResult(
    public val aliasPrefix: String? = null,
    public val aliases: List<String>,
    public val arns: List<String>,
    public val id: String,
    public val workspaceIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amp.outputs.GetWorkspacesResult): GetWorkspacesResult = GetWorkspacesResult(
            aliasPrefix = javaType.aliasPrefix().map({ args0 -> args0 }).orElse(null),
            aliases = javaType.aliases().map({ args0 -> args0 }),
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
            workspaceIds = javaType.workspaceIds().map({ args0 -> args0 }),
        )
    }
}
