@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusterArn
 * @property securityGroupIds List of the security group IDs for the Amazon EKS cluster VPC configuration.
 * @property subnetIds List of subnet IDs. Must be in at least two different availability zones.
 */
public data class ScraperSourceEks(
    public val clusterArn: String,
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amp.outputs.ScraperSourceEks): ScraperSourceEks =
            ScraperSourceEks(
                clusterArn = javaType.clusterArn(),
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            )
    }
}
