@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.AppArgs.builder
import com.pulumi.aws.amplify.kotlin.inputs.AppAutoBranchCreationConfigArgs
import com.pulumi.aws.amplify.kotlin.inputs.AppAutoBranchCreationConfigArgsBuilder
import com.pulumi.aws.amplify.kotlin.inputs.AppCustomRuleArgs
import com.pulumi.aws.amplify.kotlin.inputs.AppCustomRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *  /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /*
 * Provides an Amplify App resource, a fullstack serverless app hosted on the [AWS Amplify Console](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html).
 * > **Note:** When you create/update an Amplify App from the provider, you may end up with the error "BadRequestException: You should at least provide one valid token" because of authentication issues. See the section "Repository with Tokens" below.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     repository: "https://github.com/example/app",
 *     buildSpec: `version: 0.1
 * frontend:
 *   phases:
 *     preBuild:
 *       commands:
 *         - yarn install
 *     build:
 *       commands:
 *         - yarn run build
 *   artifacts:
 *     baseDirectory: build
 *     files:
 *       - '**/*'
 *   cache:
 *     paths:
 *       - node_modules/**/*
 * `,
 *     customRules: [{
 *         source: "/<*>",
 *         status: "404",
 *         target: "/index.html",
 *     }],
 *     environmentVariables: {
 *         ENV: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="example",
 *     repository="https://github.com/example/app",
 *     build_spec="""version: 0.1
 * frontend:
 *   phases:
 *     preBuild:
 *       commands:
 *         - yarn install
 *     build:
 *       commands:
 *         - yarn run build
 *   artifacts:
 *     baseDirectory: build
 *     files:
 *       - '**/*'
 *   cache:
 *     paths:
 *       - node_modules/**/*
 * """,
 *     custom_rules=[{
 *         "source": "/<*>",
 *         "status": "404",
 *         "target": "/index.html",
 *     }],
 *     environment_variables={
 *         "ENV": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         Repository = "https://github.com/example/app",
 *         BuildSpec = @"version: 0.1
 * frontend:
 *   phases:
 *     preBuild:
 *       commands:
 *         - yarn install
 *     build:
 *       commands:
 *         - yarn run build
 *   artifacts:
 *     baseDirectory: build
 *     files:
 *       - '**/*'
 *   cache:
 *     paths:
 *       - node_modules/**/*
 * ",
 *         CustomRules = new[]
 *         {
 *             new Aws.Amplify.Inputs.AppCustomRuleArgs
 *             {
 *                 Source = "/<*>",
 *                 Status = "404",
 *                 Target = "/index.html",
 *             },
 *         },
 *         EnvironmentVariables =
 *         {
 *             { "ENV", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name:       pulumi.String("example"),
 * 			Repository: pulumi.String("https://github.com/example/app"),
 * 			BuildSpec: pulumi.String(`version: 0.1
 * frontend:
 *   phases:
 *     preBuild:
 *       commands:
 *         - yarn install
 *     build:
 *       commands:
 *         - yarn run build
 *   artifacts:
 *     baseDirectory: build
 *     files:
 *       - '**/*'
 *   cache:
 *     paths:
 *       - node_modules/**/*
 * `),
 * 			CustomRules: amplify.AppCustomRuleArray{
 * 				&amplify.AppCustomRuleArgs{
 * 					Source: pulumi.String("/<*>"),
 * 					Status: pulumi.String("404"),
 * 					Target: pulumi.String("/index.html"),
 * 				},
 * 			},
 * 			EnvironmentVariables: pulumi.StringMap{
 * 				"ENV": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .repository("https://github.com/example/app")
 *             .buildSpec("""
 * version: 0.1
 * frontend:
 *   phases:
 *     preBuild:
 *       commands:
 *         - yarn install
 *     build:
 *       commands:
 *         - yarn run build
 *   artifacts:
 *     baseDirectory: build
 *     files:
 *       - '**/*'
 *   cache:
 *     paths:
 *       - node_modules/**/*
 *             """)
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source("/<*>")
 *                 .status("404")
 *                 .target("/index.html")
 *                 .build())
 *             .environmentVariables(Map.of("ENV", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       repository: https://github.com/example/app
 *       buildSpec: |
 *         version: 0.1
 *         frontend:
 *           phases:
 *             preBuild:
 *               commands:
 *                 - yarn install
 *             build:
 *               commands:
 *                 - yarn run build
 *           artifacts:
 *             baseDirectory: build
 *             files:
 *               - '**/*'
 *           cache:
 *             paths:
 *               - node_modules/**/*
 *       customRules:
 *         - source: /<*>
 *           status: '404'
 *           target: /index.html
 *       environmentVariables:
 *         ENV: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Repository with Tokens
 * If you create a new Amplify App with the `repository` argument, you also need to set `oauth_token` or `access_token` for authentication. For GitHub, get a [personal access token](https://help.github.com/en/github/authenticating-to-github/creating-a-personal-access-token-for-the-command-line) and set `access_token` as follows:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     repository: "https://github.com/example/app",
 *     accessToken: "...",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="example",
 *     repository="https://github.com/example/app",
 *     access_token="...")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         Repository = "https://github.com/example/app",
 *         AccessToken = "...",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name:        pulumi.String("example"),
 * 			Repository:  pulumi.String("https://github.com/example/app"),
 * 			AccessToken: pulumi.String("..."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .repository("https://github.com/example/app")
 *             .accessToken("...")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       repository: https://github.com/example/app
 *       accessToken: '...'
 * ```
 * <!--End PulumiCodeChooser -->
 * You can omit `access_token` if you import an existing Amplify App created by the Amplify Console (using OAuth for authentication).
 * ### Auto Branch Creation
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     enableAutoBranchCreation: true,
 *     autoBranchCreationPatterns: [
 *         "*",
 *         "*/**",
 *     ],
 *     autoBranchCreationConfig: {
 *         enableAutoBuild: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="example",
 *     enable_auto_branch_creation=True,
 *     auto_branch_creation_patterns=[
 *         "*",
 *         "*/**",
 *     ],
 *     auto_branch_creation_config={
 *         "enable_auto_build": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         EnableAutoBranchCreation = true,
 *         AutoBranchCreationPatterns = new[]
 *         {
 *             "*",
 *             "*/**",
 *         },
 *         AutoBranchCreationConfig = new Aws.Amplify.Inputs.AppAutoBranchCreationConfigArgs
 *         {
 *             EnableAutoBuild = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name:                     pulumi.String("example"),
 * 			EnableAutoBranchCreation: pulumi.Bool(true),
 * 			AutoBranchCreationPatterns: pulumi.StringArray{
 * 				pulumi.String("*"),
 * 				pulumi.String("*/**"),
 * 			},
 * 			AutoBranchCreationConfig: &amplify.AppAutoBranchCreationConfigArgs{
 * 				EnableAutoBuild: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .enableAutoBranchCreation(true)
 *             .autoBranchCreationPatterns(
 *                 "*",
 *                 "*/**")
 *             .autoBranchCreationConfig(AppAutoBranchCreationConfigArgs.builder()
 *                 .enableAutoBuild(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       enableAutoBranchCreation: true # The default patterns added by the Amplify Console.
 *       autoBranchCreationPatterns:
 *         - '*'
 *         - '*/**'
 *       autoBranchCreationConfig:
 *         enableAutoBuild: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Authorization
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     enableBasicAuth: true,
 *     basicAuthCredentials: std.base64encode({
 *         input: "username1:password1",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.amplify.App("example",
 *     name="example",
 *     enable_basic_auth=True,
 *     basic_auth_credentials=std.base64encode(input="username1:password1").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         EnableBasicAuth = true,
 *         BasicAuthCredentials = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "username1:password1",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "username1:password1",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name:                 pulumi.String("example"),
 * 			EnableBasicAuth:      pulumi.Bool(true),
 * 			BasicAuthCredentials: pulumi.String(invokeBase64encode.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .enableBasicAuth(true)
 *             .basicAuthCredentials(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("username1:password1")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       enableBasicAuth: true
 *       basicAuthCredentials:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: username1:password1
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Rewrites and Redirects
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     customRules: [
 *         {
 *             source: "/api/<*>",
 *             status: "200",
 *             target: "https://api.example.com/api/<*>",
 *         },
 *         {
 *             source: "</^[^&#46;]+$|\\&#46;(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^&#46;]+$)/>",
 *             status: "200",
 *             target: "/index.html",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="example",
 *     custom_rules=[
 *         {
 *             "source": "/api/<*>",
 *             "status": "200",
 *             "target": "https://api.example.com/api/<*>",
 *         },
 *         {
 *             "source": "</^[^&#46;]+$|\\&#46;(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^&#46;]+$)/>",
 *             "status": "200",
 *             "target": "/index.html",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         CustomRules = new[]
 *         {
 *             new Aws.Amplify.Inputs.AppCustomRuleArgs
 *             {
 *                 Source = "/api/<*>",
 *                 Status = "200",
 *                 Target = "https://api.example.com/api/<*>",
 *             },
 *             new Aws.Amplify.Inputs.AppCustomRuleArgs
 *             {
 *                 Source = "</^[^&#46;]+$|\\&#46;(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^&#46;]+$)/>",
 *                 Status = "200",
 *                 Target = "/index.html",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("example"),
 * 			CustomRules: amplify.AppCustomRuleArray{
 * 				&amplify.AppCustomRuleArgs{
 * 					Source: pulumi.String("/api/<*>"),
 * 					Status: pulumi.String("200"),
 * 					Target: pulumi.String("https://api.example.com/api/<*>"),
 * 				},
 * 				&amplify.AppCustomRuleArgs{
 * 					Source: pulumi.String("</^[^&#46;]+$|\\&#46;(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^&#46;]+$)/>"),
 * 					Status: pulumi.String("200"),
 * 					Target: pulumi.String("/index.html"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .customRules(
 *                 AppCustomRuleArgs.builder()
 *                     .source("/api/<*>")
 *                     .status("200")
 *                     .target("https://api.example.com/api/<*>")
 *                     .build(),
 *                 AppCustomRuleArgs.builder()
 *                     .source("</^[^&#46;]+$|\\&#46;(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^&#46;]+$)/>")
 *                     .status("200")
 *                     .target("/index.html")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       customRules:
 *         - source: /api/<*>
 *           status: '200'
 *           target: https://api.example.com/api/<*>
 *         - source: </^[^&#46;]+$|\&#46;(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^&#46;]+$)/>
 *           status: '200'
 *           target: /index.html
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Image
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     environmentVariables: {
 *         _CUSTOM_IMAGE: "node:16",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="example",
 *     environment_variables={
 *         "_CUSTOM_IMAGE": "node:16",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         EnvironmentVariables =
 *         {
 *             { "_CUSTOM_IMAGE", "node:16" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("example"),
 * 			EnvironmentVariables: pulumi.StringMap{
 * 				"_CUSTOM_IMAGE": pulumi.String("node:16"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .environmentVariables(Map.of("_CUSTOM_IMAGE", "node:16"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       environmentVariables:
 *         _CUSTOM_IMAGE: node:16
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Custom Headers
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "example",
 *     customHeaders: `customHeaders:
 *   - pattern: '**'
 *     headers:
 *       - key: 'Strict-Transport-Security'
 *         value: 'max-age=31536000; includeSubDomains'
 *       - key: 'X-Frame-Options'
 *         value: 'SAMEORIGIN'
 *       - key: 'X-XSS-Protection'
 *         value: '1; mode=block'
 *       - key: 'X-Content-Type-Options'
 *         value: 'nosniff'
 *       - key: 'Content-Security-Policy'
 *         value: "default-src 'self'"
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="example",
 *     custom_headers="""customHeaders:
 *   - pattern: '**'
 *     headers:
 *       - key: 'Strict-Transport-Security'
 *         value: 'max-age=31536000; includeSubDomains'
 *       - key: 'X-Frame-Options'
 *         value: 'SAMEORIGIN'
 *       - key: 'X-XSS-Protection'
 *         value: '1; mode=block'
 *       - key: 'X-Content-Type-Options'
 *         value: 'nosniff'
 *       - key: 'Content-Security-Policy'
 *         value: "default-src 'self'"
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "example",
 *         CustomHeaders = @"customHeaders:
 *   - pattern: '**'
 *     headers:
 *       - key: 'Strict-Transport-Security'
 *         value: 'max-age=31536000; includeSubDomains'
 *       - key: 'X-Frame-Options'
 *         value: 'SAMEORIGIN'
 *       - key: 'X-XSS-Protection'
 *         value: '1; mode=block'
 *       - key: 'X-Content-Type-Options'
 *         value: 'nosniff'
 *       - key: 'Content-Security-Policy'
 *         value: ""default-src 'self'""
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("example"),
 * 			CustomHeaders: pulumi.String(`customHeaders:
 *   - pattern: '**'
 *     headers:
 *       - key: 'Strict-Transport-Security'
 *         value: 'max-age=31536000; includeSubDomains'
 *       - key: 'X-Frame-Options'
 *         value: 'SAMEORIGIN'
 *       - key: 'X-XSS-Protection'
 *         value: '1; mode=block'
 *       - key: 'X-Content-Type-Options'
 *         value: 'nosniff'
 *       - key: 'Content-Security-Policy'
 *         value: "default-src 'self'"
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("example")
 *             .customHeaders("""
 * customHeaders:
 *   - pattern: '**'
 *     headers:
 *       - key: 'Strict-Transport-Security'
 *         value: 'max-age=31536000; includeSubDomains'
 *       - key: 'X-Frame-Options'
 *         value: 'SAMEORIGIN'
 *       - key: 'X-XSS-Protection'
 *         value: '1; mode=block'
 *       - key: 'X-Content-Type-Options'
 *         value: 'nosniff'
 *       - key: 'Content-Security-Policy'
 *         value: "default-src 'self'"
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: example
 *       customHeaders: |
 *         customHeaders:
 *           - pattern: '**'
 *             headers:
 *               - key: 'Strict-Transport-Security'
 *                 value: 'max-age=31536000; includeSubDomains'
 *               - key: 'X-Frame-Options'
 *                 value: 'SAMEORIGIN'
 *               - key: 'X-XSS-Protection'
 *                 value: '1; mode=block'
 *               - key: 'X-Content-Type-Options'
 *                 value: 'nosniff'
 *               - key: 'Content-Security-Policy'
 *                 value: "default-src 'self'"
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amplify App using Amplify App ID (appId). For example:
 * ```sh
 * $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
 * ```
 * App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).
 * @property accessToken Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
 * @property autoBranchCreationConfig Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
 * @property autoBranchCreationPatterns Automated branch creation glob patterns for an Amplify app.
 * @property basicAuthCredentials Credentials for basic authorization for an Amplify app.
 * @property buildSpec The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
 * @property customHeaders The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
 * @property customRules Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
 * @property description Description for an Amplify app.
 * @property enableAutoBranchCreation Enables automated branch creation for an Amplify app.
 * @property enableBasicAuth Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
 * @property enableBranchAutoBuild Enables auto-building of branches for the Amplify App.
 * @property enableBranchAutoDeletion Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
 * @property environmentVariables Environment variables map for an Amplify app.
 * @property iamServiceRoleArn AWS Identity and Access Management (IAM) service role for an Amplify app.
 * @property name Name for an Amplify app.
 * @property oauthToken OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
 * @property platform Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
 * @property repository Repository for an Amplify app.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */*/*/*/*/*/
 */
public data class AppArgs(
    public val accessToken: Output<String>? = null,
    public val autoBranchCreationConfig: Output<AppAutoBranchCreationConfigArgs>? = null,
    public val autoBranchCreationPatterns: Output<List<String>>? = null,
    public val basicAuthCredentials: Output<String>? = null,
    public val buildSpec: Output<String>? = null,
    public val customHeaders: Output<String>? = null,
    public val customRules: Output<List<AppCustomRuleArgs>>? = null,
    public val description: Output<String>? = null,
    public val enableAutoBranchCreation: Output<Boolean>? = null,
    public val enableBasicAuth: Output<Boolean>? = null,
    public val enableBranchAutoBuild: Output<Boolean>? = null,
    public val enableBranchAutoDeletion: Output<Boolean>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val iamServiceRoleArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val oauthToken: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val repository: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.AppArgs> {
    override fun toJava(): com.pulumi.aws.amplify.AppArgs = com.pulumi.aws.amplify.AppArgs.builder()
        .accessToken(accessToken?.applyValue({ args0 -> args0 }))
        .autoBranchCreationConfig(
            autoBranchCreationConfig?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .autoBranchCreationPatterns(
            autoBranchCreationPatterns?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .basicAuthCredentials(basicAuthCredentials?.applyValue({ args0 -> args0 }))
        .buildSpec(buildSpec?.applyValue({ args0 -> args0 }))
        .customHeaders(customHeaders?.applyValue({ args0 -> args0 }))
        .customRules(
            customRules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .description(description?.applyValue({ args0 -> args0 }))
        .enableAutoBranchCreation(enableAutoBranchCreation?.applyValue({ args0 -> args0 }))
        .enableBasicAuth(enableBasicAuth?.applyValue({ args0 -> args0 }))
        .enableBranchAutoBuild(enableBranchAutoBuild?.applyValue({ args0 -> args0 }))
        .enableBranchAutoDeletion(enableBranchAutoDeletion?.applyValue({ args0 -> args0 }))
        .environmentVariables(
            environmentVariables?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .iamServiceRoleArn(iamServiceRoleArn?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .oauthToken(oauthToken?.applyValue({ args0 -> args0 }))
        .platform(platform?.applyValue({ args0 -> args0 }))
        .repository(repository?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var autoBranchCreationConfig: Output<AppAutoBranchCreationConfigArgs>? = null

    private var autoBranchCreationPatterns: Output<List<String>>? = null

    private var basicAuthCredentials: Output<String>? = null

    private var buildSpec: Output<String>? = null

    private var customHeaders: Output<String>? = null

    private var customRules: Output<List<AppCustomRuleArgs>>? = null

    private var description: Output<String>? = null

    private var enableAutoBranchCreation: Output<Boolean>? = null

    private var enableBasicAuth: Output<Boolean>? = null

    private var enableBranchAutoBuild: Output<Boolean>? = null

    private var enableBranchAutoDeletion: Output<Boolean>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var iamServiceRoleArn: Output<String>? = null

    private var name: Output<String>? = null

    private var oauthToken: Output<String>? = null

    private var platform: Output<String>? = null

    private var repository: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
     */
    @JvmName("gmxoiauopjpeaqgw")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    @JvmName("ypxxjyohipfcahxm")
    public suspend fun autoBranchCreationConfig(`value`: Output<AppAutoBranchCreationConfigArgs>) {
        this.autoBranchCreationConfig = value
    }

    /**
     * @param value Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("toykpukbfefawnye")
    public suspend fun autoBranchCreationPatterns(`value`: Output<List<String>>) {
        this.autoBranchCreationPatterns = value
    }

    @JvmName("lfjsnxxludbmlmnf")
    public suspend fun autoBranchCreationPatterns(vararg values: Output<String>) {
        this.autoBranchCreationPatterns = Output.all(values.asList())
    }

    /**
     * @param values Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("emqccbwgxrejxjkt")
    public suspend fun autoBranchCreationPatterns(values: List<Output<String>>) {
        this.autoBranchCreationPatterns = Output.all(values)
    }

    /**
     * @param value Credentials for basic authorization for an Amplify app.
     */
    @JvmName("utoyutwsyypnubcn")
    public suspend fun basicAuthCredentials(`value`: Output<String>) {
        this.basicAuthCredentials = value
    }

    /**
     * @param value The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
     */
    @JvmName("dfgpgbnrqfsgtdjq")
    public suspend fun buildSpec(`value`: Output<String>) {
        this.buildSpec = value
    }

    /**
     * @param value The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
     */
    @JvmName("wfvwjejgiqfrfneh")
    public suspend fun customHeaders(`value`: Output<String>) {
        this.customHeaders = value
    }

    /**
     * @param value Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("rqvrpacaxdoypgiu")
    public suspend fun customRules(`value`: Output<List<AppCustomRuleArgs>>) {
        this.customRules = value
    }

    @JvmName("cjwgopasssmjakkx")
    public suspend fun customRules(vararg values: Output<AppCustomRuleArgs>) {
        this.customRules = Output.all(values.asList())
    }

    /**
     * @param values Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("bsoohloyhjupopfk")
    public suspend fun customRules(values: List<Output<AppCustomRuleArgs>>) {
        this.customRules = Output.all(values)
    }

    /**
     * @param value Description for an Amplify app.
     */
    @JvmName("hpsagweaakyqcqma")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enables automated branch creation for an Amplify app.
     */
    @JvmName("lyectwnqcdolbsmd")
    public suspend fun enableAutoBranchCreation(`value`: Output<Boolean>) {
        this.enableAutoBranchCreation = value
    }

    /**
     * @param value Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     */
    @JvmName("nufnggwmrpnmcqni")
    public suspend fun enableBasicAuth(`value`: Output<Boolean>) {
        this.enableBasicAuth = value
    }

    /**
     * @param value Enables auto-building of branches for the Amplify App.
     */
    @JvmName("toubtrgmbtpkvbbn")
    public suspend fun enableBranchAutoBuild(`value`: Output<Boolean>) {
        this.enableBranchAutoBuild = value
    }

    /**
     * @param value Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     */
    @JvmName("xkddqwhqatdoieyw")
    public suspend fun enableBranchAutoDeletion(`value`: Output<Boolean>) {
        this.enableBranchAutoDeletion = value
    }

    /**
     * @param value Environment variables map for an Amplify app.
     */
    @JvmName("ysejryrfieivinhw")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    @JvmName("ktrgxnbdckjoqird")
    public suspend fun iamServiceRoleArn(`value`: Output<String>) {
        this.iamServiceRoleArn = value
    }

    /**
     * @param value Name for an Amplify app.
     */
    @JvmName("rbhcriampgyhoclc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
     */
    @JvmName("feknpyrmwaytpfar")
    public suspend fun oauthToken(`value`: Output<String>) {
        this.oauthToken = value
    }

    /**
     * @param value Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
     */
    @JvmName("lckmamaltrebfved")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Repository for an Amplify app.
     */
    @JvmName("sbxowpbocoegxhld")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("solhliruylsrjejl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
     */
    @JvmName("ihwkyltykhfvfbre")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    @JvmName("stmnmkbbmjqjebft")
    public suspend fun autoBranchCreationConfig(`value`: AppAutoBranchCreationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBranchCreationConfig = mapped
    }

    /**
     * @param argument Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    @JvmName("jweuojbkeqlhgaxa")
    public suspend fun autoBranchCreationConfig(argument: suspend AppAutoBranchCreationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppAutoBranchCreationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoBranchCreationConfig = mapped
    }

    /**
     * @param value Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("jpexagtxqcevkkgu")
    public suspend fun autoBranchCreationPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBranchCreationPatterns = mapped
    }

    /**
     * @param values Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("cftehpyamvebeeal")
    public suspend fun autoBranchCreationPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoBranchCreationPatterns = mapped
    }

    /**
     * @param value Credentials for basic authorization for an Amplify app.
     */
    @JvmName("ftcugqbaaiswetau")
    public suspend fun basicAuthCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthCredentials = mapped
    }

    /**
     * @param value The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
     */
    @JvmName("lcddyrgcmxtlqups")
    public suspend fun buildSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildSpec = mapped
    }

    /**
     * @param value The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
     */
    @JvmName("grvvnlrhcxvtrijv")
    public suspend fun customHeaders(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("lvsabmytoakrbunf")
    public suspend fun customRules(`value`: List<AppCustomRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param argument Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("cecqefdwvuypupbi")
    public suspend fun customRules(argument: List<suspend AppCustomRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AppCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("rwgqthhaycekgysn")
    public suspend fun customRules(vararg argument: suspend AppCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AppCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("ckaaphysgwavuhwa")
    public suspend fun customRules(argument: suspend AppCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AppCustomRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param values Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("qsansophnqgaymla")
    public suspend fun customRules(vararg values: AppCustomRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param value Description for an Amplify app.
     */
    @JvmName("sngmmagqrcmwxmpc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enables automated branch creation for an Amplify app.
     */
    @JvmName("bdsmptagtqogwnco")
    public suspend fun enableAutoBranchCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoBranchCreation = mapped
    }

    /**
     * @param value Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     */
    @JvmName("nlfgymbsgtidavbq")
    public suspend fun enableBasicAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBasicAuth = mapped
    }

    /**
     * @param value Enables auto-building of branches for the Amplify App.
     */
    @JvmName("hwlyjwtidexdsppt")
    public suspend fun enableBranchAutoBuild(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBranchAutoBuild = mapped
    }

    /**
     * @param value Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     */
    @JvmName("phchercwfqwrdkvg")
    public suspend fun enableBranchAutoDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBranchAutoDeletion = mapped
    }

    /**
     * @param value Environment variables map for an Amplify app.
     */
    @JvmName("fdwkntvsffyhnqit")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables map for an Amplify app.
     */
    @JvmName("ebivvyleeiaxrylk")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    @JvmName("lbhycgwaqfsmkqkl")
    public suspend fun iamServiceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamServiceRoleArn = mapped
    }

    /**
     * @param value Name for an Amplify app.
     */
    @JvmName("pglmahosdvkebmts")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
     */
    @JvmName("vawklkjnckqjbguk")
    public suspend fun oauthToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthToken = mapped
    }

    /**
     * @param value Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
     */
    @JvmName("mvlhkhkmxppoprft")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Repository for an Amplify app.
     */
    @JvmName("dxmimixbrutsiksh")
    public suspend fun repository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fmideghttclpywky")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bpfxuewtcmsrifsk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        accessToken = accessToken,
        autoBranchCreationConfig = autoBranchCreationConfig,
        autoBranchCreationPatterns = autoBranchCreationPatterns,
        basicAuthCredentials = basicAuthCredentials,
        buildSpec = buildSpec,
        customHeaders = customHeaders,
        customRules = customRules,
        description = description,
        enableAutoBranchCreation = enableAutoBranchCreation,
        enableBasicAuth = enableBasicAuth,
        enableBranchAutoBuild = enableBranchAutoBuild,
        enableBranchAutoDeletion = enableBranchAutoDeletion,
        environmentVariables = environmentVariables,
        iamServiceRoleArn = iamServiceRoleArn,
        name = name,
        oauthToken = oauthToken,
        platform = platform,
        repository = repository,
        tags = tags,
    )
}
