@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Branch].
 */
@PulumiTagMarker
public class BranchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BranchArgs = BranchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BranchArgsBuilder.() -> Unit) {
        val builder = BranchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Branch {
        val builtJavaResource = com.pulumi.aws.amplify.Branch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Branch(builtJavaResource)
    }
}

/**
 * Provides an Amplify Branch resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {name: "app"});
 * const master = new aws.amplify.Branch("master", {
 *     appId: example.id,
 *     branchName: "master",
 *     framework: "React",
 *     stage: "PRODUCTION",
 *     environmentVariables: {
 *         REACT_APP_API_SERVER: "https://api.example.com",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example", name="app")
 * master = aws.amplify.Branch("master",
 *     app_id=example.id,
 *     branch_name="master",
 *     framework="React",
 *     stage="PRODUCTION",
 *     environment_variables={
 *         "REACT_APP_API_SERVER": "https://api.example.com",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "app",
 *     });
 *     var master = new Aws.Amplify.Branch("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = "master",
 *         Framework = "React",
 *         Stage = "PRODUCTION",
 *         EnvironmentVariables =
 *         {
 *             { "REACT_APP_API_SERVER", "https://api.example.com" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amplify.NewBranch(ctx, "master", &amplify.BranchArgs{
 * 			AppId:      example.ID(),
 * 			BranchName: pulumi.String("master"),
 * 			Framework:  pulumi.String("React"),
 * 			Stage:      pulumi.String("PRODUCTION"),
 * 			EnvironmentVariables: pulumi.StringMap{
 * 				"REACT_APP_API_SERVER": pulumi.String("https://api.example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("app")
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .framework("React")
 *             .stage("PRODUCTION")
 *             .environmentVariables(Map.of("REACT_APP_API_SERVER", "https://api.example.com"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: app
 *   master:
 *     type: aws:amplify:Branch
 *     properties:
 *       appId: ${example.id}
 *       branchName: master
 *       framework: React
 *       stage: PRODUCTION
 *       environmentVariables:
 *         REACT_APP_API_SERVER: https://api.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.amplify.App("example", {name: "app"});
 * const master = new aws.amplify.Branch("master", {
 *     appId: example.id,
 *     branchName: "master",
 *     enableBasicAuth: true,
 *     basicAuthCredentials: std.base64encode({
 *         input: "username:password",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.amplify.App("example", name="app")
 * master = aws.amplify.Branch("master",
 *     app_id=example.id,
 *     branch_name="master",
 *     enable_basic_auth=True,
 *     basic_auth_credentials=std.base64encode(input="username:password").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "app",
 *     });
 *     var master = new Aws.Amplify.Branch("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = "master",
 *         EnableBasicAuth = true,
 *         BasicAuthCredentials = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "username:password",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "username:password",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amplify.NewBranch(ctx, "master", &amplify.BranchArgs{
 * 			AppId:                example.ID(),
 * 			BranchName:           pulumi.String("master"),
 * 			EnableBasicAuth:      pulumi.Bool(true),
 * 			BasicAuthCredentials: pulumi.String(invokeBase64encode.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("app")
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .enableBasicAuth(true)
 *             .basicAuthCredentials(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("username:password")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: app
 *   master:
 *     type: aws:amplify:Branch
 *     properties:
 *       appId: ${example.id}
 *       branchName: master
 *       enableBasicAuth: true
 *       basicAuthCredentials:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: username:password
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Notifications
 * Amplify Console uses EventBridge (formerly known as CloudWatch Events) and SNS for email notifications.  To implement the same functionality, you need to set `enable_notification` in a `aws.amplify.Branch` resource, as well as creating an EventBridge Rule, an SNS topic, and SNS subscriptions.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {name: "app"});
 * const master = new aws.amplify.Branch("master", {
 *     appId: example.id,
 *     branchName: "master",
 *     enableNotification: true,
 * });
 * // EventBridge Rule for Amplify notifications
 * const amplifyAppMasterEventRule = new aws.cloudwatch.EventRule("amplify_app_master", {
 *     name: pulumi.interpolate`amplify-${app.id}-${master.branchName}-branch-notification`,
 *     description: pulumi.interpolate`AWS Amplify build notifications for :  App: ${app.id} Branch: ${master.branchName}`,
 *     eventPattern: pulumi.jsonStringify({
 *         detail: {
 *             appId: [example&#46;id],
 *             branchName: [master&#46;branchName],
 *             jobStatus: [
 *                 "SUCCEED",
 *                 "FAILED",
 *                 "STARTED",
 *             ],
 *         },
 *         "detail-type": ["Amplify Deployment Status Change"],
 *         source: ["aws&#46;amplify"],
 *     }),
 * });
 * // SNS Topic for Amplify notifications
 * const amplifyAppMasterTopic = new aws.sns.Topic("amplify_app_master", {name: pulumi.interpolate`amplify-${app.id}_${master.branchName}`});
 * const amplifyAppMasterEventTarget = new aws.cloudwatch.EventTarget("amplify_app_master", {
 *     rule: amplifyAppMasterEventRule.name,
 *     targetId: master.branchName,
 *     arn: amplifyAppMasterTopic.arn,
 *     inputTransformer: {
 *         inputPaths: {
 *             jobId: "$.detail.jobId",
 *             appId: "$.detail.appId",
 *             region: "$.region",
 *             branch: "$.detail.branchName",
 *             status: "$.detail.jobStatus",
 *         },
 *         inputTemplate: "\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \"",
 *     },
 * });
 * const amplifyAppMaster = pulumi.all([master&#46;arn, amplifyAppMasterTopic&#46;arn])&#46;apply(([masterArn, amplifyAppMasterTopicArn]) => aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         sid: `Allow_Publish_Events ${masterArn}`,
 *         effect: "Allow",
 *         actions: ["SNS:Publish"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["events&#46;amazonaws&#46;com"],
 *         }],
 *         resources: [amplifyAppMasterTopicArn],
 *     }],
 * }));
 * const amplifyAppMasterTopicPolicy = new aws.sns.TopicPolicy("amplify_app_master", {
 *     arn: amplifyAppMasterTopic.arn,
 *     policy: amplifyAppMaster.apply(amplifyAppMaster => amplifyAppMaster.json),
 * });
 * const _this = new aws.sns.TopicSubscription("this", {
 *     topic: amplifyAppMasterTopic.arn,
 *     protocol: "email",
 *     endpoint: "user@acme.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.amplify.App("example", name="app")
 * master = aws.amplify.Branch("master",
 *     app_id=example.id,
 *     branch_name="master",
 *     enable_notification=True)
 * # EventBridge Rule for Amplify notifications
 * amplify_app_master_event_rule = aws.cloudwatch.EventRule("amplify_app_master",
 *     name=master.branch_name.apply(lambda branch_name: f"amplify-{app['id']}-{branch_name}-branch-notification"),
 *     description=master.branch_name.apply(lambda branch_name: f"AWS Amplify build notifications for :  App: {app['id']} Branch: {branch_name}"),
 *     event_pattern=pulumi.Output.json_dumps({
 *         "detail": {
 *             "appId": [example&#46;id],
 *             "branchName": [master&#46;branch_name],
 *             "jobStatus": [
 *                 "SUCCEED",
 *                 "FAILED",
 *                 "STARTED",
 *             ],
 *         },
 *         "detail-type": ["Amplify Deployment Status Change"],
 *         "source": ["aws&#46;amplify"],
 *     }))
 * # SNS Topic for Amplify notifications
 * amplify_app_master_topic = aws.sns.Topic("amplify_app_master", name=master.branch_name.apply(lambda branch_name: f"amplify-{app['id']}_{branch_name}"))
 * amplify_app_master_event_target = aws.cloudwatch.EventTarget("amplify_app_master",
 *     rule=amplify_app_master_event_rule.name,
 *     target_id=master.branch_name,
 *     arn=amplify_app_master_topic.arn,
 *     input_transformer={
 *         "input_paths": {
 *             "job_id": "$.detail.jobId",
 *             "app_id": "$.detail.appId",
 *             "region": "$.region",
 *             "branch": "$.detail.branchName",
 *             "status": "$.detail.jobStatus",
 *         },
 *         "input_template": "\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \"",
 *     })
 * amplify_app_master = pulumi.Output.all(master.arn, amplify_app_master_topic.arn).apply(lambda masterArn, amplifyAppMasterTopicArn: aws.iam.get_policy_document_output(statements=[{
 *     "sid": f"Allow_Publish_Events {master_arn}",
 *     "effect": "Allow",
 *     "actions": ["SNS:Publish"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["events&#46;amazonaws&#46;com"],
 *     }],
 *     "resources": [amplify_app_master_topic_arn],
 * }]))
 * amplify_app_master_topic_policy = aws.sns.TopicPolicy("amplify_app_master",
 *     arn=amplify_app_master_topic.arn,
 *     policy=amplify_app_master.json)
 * this = aws.sns.TopicSubscription("this",
 *     topic=amplify_app_master_topic.arn,
 *     protocol="email",
 *     endpoint="user@acme.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "app",
 *     });
 *     var master = new Aws.Amplify.Branch("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = "master",
 *         EnableNotification = true,
 *     });
 *     // EventBridge Rule for Amplify notifications
 *     var amplifyAppMasterEventRule = new Aws.CloudWatch.EventRule("amplify_app_master", new()
 *     {
 *         Name = master.BranchName.Apply(branchName => $"amplify-{app.Id}-{branchName}-branch-notification"),
 *         Description = master.BranchName.Apply(branchName => $"AWS Amplify build notifications for :  App: {app.Id} Branch: {branchName}"),
 *         EventPattern = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["detail"] = new Dictionary<string, object?>
 *             {
 *                 ["appId"] = new[]
 *                 {
 *                     example.Id,
 *                 },
 *                 ["branchName"] = new[]
 *                 {
 *                     master.BranchName,
 *                 },
 *                 ["jobStatus"] = new[]
 *                 {
 *                     "SUCCEED",
 *                     "FAILED",
 *                     "STARTED",
 *                 },
 *             },
 *             ["detail-type"] = new[]
 *             {
 *                 "Amplify Deployment Status Change",
 *             },
 *             ["source"] = new[]
 *             {
 *                 "aws.amplify",
 *             },
 *         })),
 *     });
 *     // SNS Topic for Amplify notifications
 *     var amplifyAppMasterTopic = new Aws.Sns.Topic("amplify_app_master", new()
 *     {
 *         Name = master.BranchName.Apply(branchName => $"amplify-{app.Id}_{branchName}"),
 *     });
 *     var amplifyAppMasterEventTarget = new Aws.CloudWatch.EventTarget("amplify_app_master", new()
 *     {
 *         Rule = amplifyAppMasterEventRule.Name,
 *         TargetId = master.BranchName,
 *         Arn = amplifyAppMasterTopic.Arn,
 *         InputTransformer = new Aws.CloudWatch.Inputs.EventTargetInputTransformerArgs
 *         {
 *             InputPaths =
 *             {
 *                 { "jobId", "$.detail.jobId" },
 *                 { "appId", "$.detail.appId" },
 *                 { "region", "$.region" },
 *                 { "branch", "$.detail.branchName" },
 *                 { "status", "$.detail.jobStatus" },
 *             },
 *             InputTemplate = "\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \"",
 *         },
 *     });
 *     var amplifyAppMaster = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = $"Allow_Publish_Events {master.Arn}",
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "SNS:Publish",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "events.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Resources = new[]
 *                 {
 *                     amplifyAppMasterTopic.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var amplifyAppMasterTopicPolicy = new Aws.Sns.TopicPolicy("amplify_app_master", new()
 *     {
 *         Arn = amplifyAppMasterTopic.Arn,
 *         Policy = amplifyAppMaster.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var @this = new Aws.Sns.TopicSubscription("this", new()
 *     {
 *         Topic = amplifyAppMasterTopic.Arn,
 *         Protocol = "email",
 *         Endpoint = "user@acme.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * example, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * Name: pulumi.String("app"),
 * })
 * if err != nil {
 * return err
 * }
 * master, err := amplify.NewBranch(ctx, "master", &amplify.BranchArgs{
 * AppId: example.ID(),
 * BranchName: pulumi.String("master"),
 * EnableNotification: pulumi.Bool(true),
 * })
 * if err != nil {
 * return err
 * }
 * // EventBridge Rule for Amplify notifications
 * amplifyAppMasterEventRule, err := cloudwatch.NewEventRule(ctx, "amplify_app_master", &cloudwatch.EventRuleArgs{
 * Name: master.BranchName.ApplyT(func(branchName string) (string, error) {
 * return fmt.Sprintf("amplify-%v-%v-branch-notification", app.Id, branchName), nil
 * }).(pulumi.StringOutput),
 * Description: master.BranchName.ApplyT(func(branchName string) (string, error) {
 * return fmt.Sprintf("AWS Amplify build notifications for :  App: %v Branch: %v", app.Id, branchName), nil
 * }).(pulumi.StringOutput),
 * EventPattern: pulumi.All(example.ID(),master.BranchName).ApplyT(func(_args []interface{}) (string, error) {
 * id := _args[0].(string)
 * branchName := _args[1].(string)
 * var _zero string
 * tmpJSON0, err := json.Marshal(map[string]interface{}{
 * "detail": map[string]interface{}{
 * "appId": []string{
 * id,
 * },
 * "branchName": []string{
 * branchName,
 * },
 * "jobStatus": []string{
 * "SUCCEED",
 * "FAILED",
 * "STARTED",
 * },
 * },
 * "detail-type": []string{
 * "Amplify Deployment Status Change",
 * },
 * "source": []string{
 * "aws.amplify",
 * },
 * })
 * if err != nil {
 * return _zero, err
 * }
 * json0 := string(tmpJSON0)
 * return json0, nil
 * }).(pulumi.StringOutput),
 * })
 * if err != nil {
 * return err
 * }
 * // SNS Topic for Amplify notifications
 * amplifyAppMasterTopic, err := sns.NewTopic(ctx, "amplify_app_master", &sns.TopicArgs{
 * Name: master.BranchName.ApplyT(func(branchName string) (string, error) {
 * return fmt.Sprintf("amplify-%v_%v", app.Id, branchName), nil
 * }).(pulumi.StringOutput),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = cloudwatch.NewEventTarget(ctx, "amplify_app_master", &cloudwatch.EventTargetArgs{
 * Rule: amplifyAppMasterEventRule.Name,
 * TargetId: master.BranchName,
 * Arn: amplifyAppMasterTopic.Arn,
 * InputTransformer: &cloudwatch.EventTargetInputTransformerArgs{
 * InputPaths: pulumi.StringMap{
 * "jobId": pulumi.String("$.detail.jobId"),
 * "appId": pulumi.String("$.detail.appId"),
 * "region": pulumi.String("$.region"),
 * "branch": pulumi.String("$.detail.branchName"),
 * "status": pulumi.String("$.detail.jobStatus"),
 * },
 * InputTemplate: pulumi.String("\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \""),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * amplifyAppMaster := pulumi.All(master.Arn,amplifyAppMasterTopic.Arn).ApplyT(func(_args []interface{}) (iam.GetPolicyDocumentResult, error) {
 * masterArn := _args[0].(string)
 * amplifyAppMasterTopicArn := _args[1].(string)
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Sid: fmt.Sprintf("Allow_Publish_Events %v", masterArn),
 * Effect: "Allow",
 * Actions: []string{
 * "SNS:Publish",
 * },
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "events.amazonaws.com",
 * },
 * },
 * },
 * Resources: interface{}{
 * amplifyAppMasterTopicArn,
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = sns.NewTopicPolicy(ctx, "amplify_app_master", &sns.TopicPolicyArgs{
 * Arn: amplifyAppMasterTopic.Arn,
 * Policy: pulumi.String(amplifyAppMaster.ApplyT(func(amplifyAppMaster iam.GetPolicyDocumentResult) (*string, error) {
 * return &amplifyAppMaster.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = sns.NewTopicSubscription(ctx, "this", &sns.TopicSubscriptionArgs{
 * Topic: amplifyAppMasterTopic.Arn,
 * Protocol: pulumi.String("email"),
 * Endpoint: pulumi.String("user@acme.com"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.sns.TopicSubscription;
 * import com.pulumi.aws.sns.TopicSubscriptionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("app")
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .enableNotification(true)
 *             .build());
 *         // EventBridge Rule for Amplify notifications
 *         var amplifyAppMasterEventRule = new EventRule("amplifyAppMasterEventRule", EventRuleArgs.builder()
 *             .name(master.branchName().applyValue(branchName -> String.format("amplify-%s-%s-branch-notification", app.id(),branchName)))
 *             .description(master.branchName().applyValue(branchName -> String.format("AWS Amplify build notifications for :  App: %s Branch: %s", app.id(),branchName)))
 *             .eventPattern(Output.tuple(example.id(), master.branchName()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var branchName = values.t2;
 *                 return serializeJson(
 *                     jsonObject(
 *                         jsonProperty("detail", jsonObject(
 *                             jsonProperty("appId", jsonArray(id)),
 *                             jsonProperty("branchName", jsonArray(branchName)),
 *                             jsonProperty("jobStatus", jsonArray(
 *                                 "SUCCEED",
 *                                 "FAILED",
 *                                 "STARTED"
 *                             ))
 *                         )),
 *                         jsonProperty("detail-type", jsonArray("Amplify Deployment Status Change")),
 *                         jsonProperty("source", jsonArray("aws.amplify"))
 *                     ));
 *             }))
 *             .build());
 *         // SNS Topic for Amplify notifications
 *         var amplifyAppMasterTopic = new Topic("amplifyAppMasterTopic", TopicArgs.builder()
 *             .name(master.branchName().applyValue(branchName -> String.format("amplify-%s_%s", app.id(),branchName)))
 *             .build());
 *         var amplifyAppMasterEventTarget = new EventTarget("amplifyAppMasterEventTarget", EventTargetArgs.builder()
 *             .rule(amplifyAppMasterEventRule.name())
 *             .targetId(master.branchName())
 *             .arn(amplifyAppMasterTopic.arn())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("jobId", "$.detail.jobId"),
 *                     Map.entry("appId", "$.detail.appId"),
 *                     Map.entry("region", "$.region"),
 *                     Map.entry("branch", "$.detail.branchName"),
 *                     Map.entry("status", "$.detail.jobStatus")
 *                 ))
 *                 .inputTemplate("\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \"")
 *                 .build())
 *             .build());
 *         final var amplifyAppMaster = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid(master.arn().applyValue(arn -> String.format("Allow_Publish_Events %s", arn)))
 *                 .effect("Allow")
 *                 .actions("SNS:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .resources(amplifyAppMasterTopic.arn())
 *                 .build())
 *             .build());
 *         var amplifyAppMasterTopicPolicy = new TopicPolicy("amplifyAppMasterTopicPolicy", TopicPolicyArgs.builder()
 *             .arn(amplifyAppMasterTopic.arn())
 *             .policy(amplifyAppMaster.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(amplifyAppMaster -> amplifyAppMaster.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var this_ = new TopicSubscription("this", TopicSubscriptionArgs.builder()
 *             .topic(amplifyAppMasterTopic.arn())
 *             .protocol("email")
 *             .endpoint("user@acme.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: app
 *   master:
 *     type: aws:amplify:Branch
 *     properties:
 *       appId: ${example.id}
 *       branchName: master
 *       enableNotification: true
 *   # EventBridge Rule for Amplify notifications
 *   amplifyAppMasterEventRule:
 *     type: aws:cloudwatch:EventRule
 *     name: amplify_app_master
 *     properties:
 *       name: amplify-${app.id}-${master.branchName}-branch-notification
 *       description: 'AWS Amplify build notifications for :  App: ${app.id} Branch: ${master.branchName}'
 *       eventPattern:
 *         fn::toJSON:
 *           detail:
 *             appId:
 *               - ${example.id}
 *             branchName:
 *               - ${master.branchName}
 *             jobStatus:
 *               - SUCCEED
 *               - FAILED
 *               - STARTED
 *           detail-type:
 *             - Amplify Deployment Status Change
 *           source:
 *             - aws.amplify
 *   amplifyAppMasterEventTarget:
 *     type: aws:cloudwatch:EventTarget
 *     name: amplify_app_master
 *     properties:
 *       rule: ${amplifyAppMasterEventRule.name}
 *       targetId: ${master.branchName}
 *       arn: ${amplifyAppMasterTopic.arn}
 *       inputTransformer:
 *         inputPaths:
 *           jobId: $.detail.jobId
 *           appId: $.detail.appId
 *           region: $.region
 *           branch: $.detail.branchName
 *           status: $.detail.jobStatus
 *         inputTemplate: '"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. "'
 *   # SNS Topic for Amplify notifications
 *   amplifyAppMasterTopic:
 *     type: aws:sns:Topic
 *     name: amplify_app_master
 *     properties:
 *       name: amplify-${app.id}_${master.branchName}
 *   amplifyAppMasterTopicPolicy:
 *     type: aws:sns:TopicPolicy
 *     name: amplify_app_master
 *     properties:
 *       arn: ${amplifyAppMasterTopic.arn}
 *       policy: ${amplifyAppMaster.json}
 *   this:
 *     type: aws:sns:TopicSubscription
 *     properties:
 *       topic: ${amplifyAppMasterTopic.arn}
 *       protocol: email
 *       endpoint: user@acme.com
 * variables:
 *   amplifyAppMaster:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: Allow_Publish_Events ${master.arn}
 *             effect: Allow
 *             actions:
 *               - SNS:Publish
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - events.amazonaws.com
 *             resources:
 *               - ${amplifyAppMasterTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amplify branch using `app_id` and `branch_name`. For example:
 * ```sh
 * $ pulumi import aws:amplify/branch:Branch master d2ypk4k47z8u6/master
 * ```
 */
public class Branch internal constructor(
    override val javaResource: com.pulumi.aws.amplify.Branch,
) : KotlinCustomResource(javaResource, BranchMapper) {
    /**
     * Unique ID for an Amplify app.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * ARN for the branch.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of custom resources that are linked to this branch.
     */
    public val associatedResources: Output<List<String>>
        get() = javaResource.associatedResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARN for a backend environment that is part of an Amplify app.
     */
    public val backendEnvironmentArn: Output<String>?
        get() = javaResource.backendEnvironmentArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Basic authorization credentials for the branch.
     */
    public val basicAuthCredentials: Output<String>?
        get() = javaResource.basicAuthCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the branch.
     */
    public val branchName: Output<String>
        get() = javaResource.branchName().applyValue({ args0 -> args0 })

    /**
     * Custom domains for the branch.
     */
    public val customDomains: Output<List<String>>
        get() = javaResource.customDomains().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Description for the branch.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Destination branch if the branch is a pull request branch.
     */
    public val destinationBranch: Output<String>
        get() = javaResource.destinationBranch().applyValue({ args0 -> args0 })

    /**
     * Display name for a branch. This is used as the default domain prefix.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Enables auto building for the branch.
     */
    public val enableAutoBuild: Output<Boolean>?
        get() = javaResource.enableAutoBuild().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables basic authorization for the branch.
     */
    public val enableBasicAuth: Output<Boolean>?
        get() = javaResource.enableBasicAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables notifications for the branch.
     */
    public val enableNotification: Output<Boolean>?
        get() = javaResource.enableNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables performance mode for the branch.
     */
    public val enablePerformanceMode: Output<Boolean>?
        get() = javaResource.enablePerformanceMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables pull request previews for this branch.
     */
    public val enablePullRequestPreview: Output<Boolean>?
        get() = javaResource.enablePullRequestPreview().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Environment variables for the branch.
     */
    public val environmentVariables: Output<Map<String, String>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Framework for the branch.
     */
    public val framework: Output<String>?
        get() = javaResource.framework().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amplify environment name for the pull request.
     */
    public val pullRequestEnvironmentName: Output<String>?
        get() = javaResource.pullRequestEnvironmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Source branch if the branch is a pull request branch.
     */
    public val sourceBranch: Output<String>
        get() = javaResource.sourceBranch().applyValue({ args0 -> args0 })

    /**
     * Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
     */
    public val stage: Output<String>?
        get() = javaResource.stage().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Content Time To Live (TTL) for the website in seconds.
     */
    public val ttl: Output<String>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BranchMapper : ResourceMapper<Branch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amplify.Branch::class == javaResource::class

    override fun map(javaResource: Resource): Branch = Branch(
        javaResource as
            com.pulumi.aws.amplify.Branch,
    )
}

/**
 * @see [Branch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Branch].
 */
public suspend fun branch(name: String, block: suspend BranchResourceBuilder.() -> Unit): Branch {
    val builder = BranchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Branch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun branch(name: String): Branch {
    val builder = BranchResourceBuilder()
    builder.name(name)
    return builder.build()
}
