@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.kotlin.outputs.DomainAssociationCertificateSettings
import com.pulumi.aws.amplify.kotlin.outputs.DomainAssociationSubDomain
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.amplify.kotlin.outputs.DomainAssociationCertificateSettings.Companion.toKotlin as domainAssociationCertificateSettingsToKotlin
import com.pulumi.aws.amplify.kotlin.outputs.DomainAssociationSubDomain.Companion.toKotlin as domainAssociationSubDomainToKotlin

/**
 * Builder for [DomainAssociation].
 */
@PulumiTagMarker
public class DomainAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainAssociationArgs = DomainAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainAssociationArgsBuilder.() -> Unit) {
        val builder = DomainAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainAssociation {
        val builtJavaResource = com.pulumi.aws.amplify.DomainAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainAssociation(builtJavaResource)
    }
}

/**
 * Provides an Amplify Domain Association resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "app",
 *     customRules: [{
 *         source: "https://example.com",
 *         status: "302",
 *         target: "https://www.example.com",
 *     }],
 * });
 * const master = new aws.amplify.Branch("master", {
 *     appId: example.id,
 *     branchName: "master",
 * });
 * const exampleDomainAssociation = new aws.amplify.DomainAssociation("example", {
 *     appId: example.id,
 *     domainName: "example.com",
 *     subDomains: [
 *         {
 *             branchName: master.branchName,
 *             prefix: "",
 *         },
 *         {
 *             branchName: master.branchName,
 *             prefix: "www",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="app",
 *     custom_rules=[{
 *         "source": "https://example.com",
 *         "status": "302",
 *         "target": "https://www.example.com",
 *     }])
 * master = aws.amplify.Branch("master",
 *     app_id=example.id,
 *     branch_name="master")
 * example_domain_association = aws.amplify.DomainAssociation("example",
 *     app_id=example.id,
 *     domain_name="example.com",
 *     sub_domains=[
 *         {
 *             "branch_name": master.branch_name,
 *             "prefix": "",
 *         },
 *         {
 *             "branch_name": master.branch_name,
 *             "prefix": "www",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "app",
 *         CustomRules = new[]
 *         {
 *             new Aws.Amplify.Inputs.AppCustomRuleArgs
 *             {
 *                 Source = "https://example.com",
 *                 Status = "302",
 *                 Target = "https://www.example.com",
 *             },
 *         },
 *     });
 *     var master = new Aws.Amplify.Branch("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = "master",
 *     });
 *     var exampleDomainAssociation = new Aws.Amplify.DomainAssociation("example", new()
 *     {
 *         AppId = example.Id,
 *         DomainName = "example.com",
 *         SubDomains = new[]
 *         {
 *             new Aws.Amplify.Inputs.DomainAssociationSubDomainArgs
 *             {
 *                 BranchName = master.BranchName,
 *                 Prefix = "",
 *             },
 *             new Aws.Amplify.Inputs.DomainAssociationSubDomainArgs
 *             {
 *                 BranchName = master.BranchName,
 *                 Prefix = "www",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("app"),
 * 			CustomRules: amplify.AppCustomRuleArray{
 * 				&amplify.AppCustomRuleArgs{
 * 					Source: pulumi.String("https://example.com"),
 * 					Status: pulumi.String("302"),
 * 					Target: pulumi.String("https://www.example.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		master, err := amplify.NewBranch(ctx, "master", &amplify.BranchArgs{
 * 			AppId:      example.ID(),
 * 			BranchName: pulumi.String("master"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amplify.NewDomainAssociation(ctx, "example", &amplify.DomainAssociationArgs{
 * 			AppId:      example.ID(),
 * 			DomainName: pulumi.String("example.com"),
 * 			SubDomains: amplify.DomainAssociationSubDomainArray{
 * 				&amplify.DomainAssociationSubDomainArgs{
 * 					BranchName: master.BranchName,
 * 					Prefix:     pulumi.String(""),
 * 				},
 * 				&amplify.DomainAssociationSubDomainArgs{
 * 					BranchName: master.BranchName,
 * 					Prefix:     pulumi.String("www"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.amplify.DomainAssociation;
 * import com.pulumi.aws.amplify.DomainAssociationArgs;
 * import com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("app")
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source("https://example.com")
 *                 .status("302")
 *                 .target("https://www.example.com")
 *                 .build())
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .build());
 *         var exampleDomainAssociation = new DomainAssociation("exampleDomainAssociation", DomainAssociationArgs.builder()
 *             .appId(example.id())
 *             .domainName("example.com")
 *             .subDomains(
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix("")
 *                     .build(),
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix("www")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: app
 *       customRules:
 *         - source: https://example.com
 *           status: '302'
 *           target: https://www.example.com
 *   master:
 *     type: aws:amplify:Branch
 *     properties:
 *       appId: ${example.id}
 *       branchName: master
 *   exampleDomainAssociation:
 *     type: aws:amplify:DomainAssociation
 *     name: example
 *     properties:
 *       appId: ${example.id}
 *       domainName: example.com
 *       subDomains:
 *         - branchName: ${master.branchName}
 *           prefix:
 *         - branchName: ${master.branchName}
 *           prefix: www
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amplify domain association using `app_id` and `domain_name`. For example:
 * ```sh
 * $ pulumi import aws:amplify/domainAssociation:DomainAssociation app d2ypk4k47z8u6/example.com
 * ```
 */
public class DomainAssociation internal constructor(
    override val javaResource: com.pulumi.aws.amplify.DomainAssociation,
) : KotlinCustomResource(javaResource, DomainAssociationMapper) {
    /**
     * Unique ID for an Amplify app.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * ARN for the domain association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of SSL/TLS certificate to use for your custom domain. If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
     */
    public val certificateSettings: Output<DomainAssociationCertificateSettings>?
        get() = javaResource.certificateSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainAssociationCertificateSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * DNS records for certificate verification in a space-delimited format (`<record> CNAME <target>`).
     */
    public val certificateVerificationDnsRecord: Output<String>
        get() = javaResource.certificateVerificationDnsRecord().applyValue({ args0 -> args0 })

    /**
     * Domain name for the domain association.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Enables the automated creation of subdomains for branches.
     */
    public val enableAutoSubDomain: Output<Boolean>?
        get() = javaResource.enableAutoSubDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Setting for the subdomain. Documented below.
     */
    public val subDomains: Output<List<DomainAssociationSubDomain>>
        get() = javaResource.subDomains().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainAssociationSubDomainToKotlin(args0)
                })
            })
        })

    /**
     * If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     */
    public val waitForVerification: Output<Boolean>?
        get() = javaResource.waitForVerification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DomainAssociationMapper : ResourceMapper<DomainAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amplify.DomainAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DomainAssociation = DomainAssociation(
        javaResource as
            com.pulumi.aws.amplify.DomainAssociation,
    )
}

/**
 * @see [DomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainAssociation].
 */
public suspend fun domainAssociation(
    name: String,
    block: suspend DomainAssociationResourceBuilder.() -> Unit,
): DomainAssociation {
    val builder = DomainAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainAssociation(name: String): DomainAssociation {
    val builder = DomainAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
