@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.DomainAssociationArgs.builder
import com.pulumi.aws.amplify.kotlin.inputs.DomainAssociationCertificateSettingsArgs
import com.pulumi.aws.amplify.kotlin.inputs.DomainAssociationCertificateSettingsArgsBuilder
import com.pulumi.aws.amplify.kotlin.inputs.DomainAssociationSubDomainArgs
import com.pulumi.aws.amplify.kotlin.inputs.DomainAssociationSubDomainArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amplify Domain Association resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {
 *     name: "app",
 *     customRules: [{
 *         source: "https://example.com",
 *         status: "302",
 *         target: "https://www.example.com",
 *     }],
 * });
 * const master = new aws.amplify.Branch("master", {
 *     appId: example.id,
 *     branchName: "master",
 * });
 * const exampleDomainAssociation = new aws.amplify.DomainAssociation("example", {
 *     appId: example.id,
 *     domainName: "example.com",
 *     subDomains: [
 *         {
 *             branchName: master.branchName,
 *             prefix: "",
 *         },
 *         {
 *             branchName: master.branchName,
 *             prefix: "www",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example",
 *     name="app",
 *     custom_rules=[{
 *         "source": "https://example.com",
 *         "status": "302",
 *         "target": "https://www.example.com",
 *     }])
 * master = aws.amplify.Branch("master",
 *     app_id=example.id,
 *     branch_name="master")
 * example_domain_association = aws.amplify.DomainAssociation("example",
 *     app_id=example.id,
 *     domain_name="example.com",
 *     sub_domains=[
 *         {
 *             "branch_name": master.branch_name,
 *             "prefix": "",
 *         },
 *         {
 *             "branch_name": master.branch_name,
 *             "prefix": "www",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "app",
 *         CustomRules = new[]
 *         {
 *             new Aws.Amplify.Inputs.AppCustomRuleArgs
 *             {
 *                 Source = "https://example.com",
 *                 Status = "302",
 *                 Target = "https://www.example.com",
 *             },
 *         },
 *     });
 *     var master = new Aws.Amplify.Branch("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = "master",
 *     });
 *     var exampleDomainAssociation = new Aws.Amplify.DomainAssociation("example", new()
 *     {
 *         AppId = example.Id,
 *         DomainName = "example.com",
 *         SubDomains = new[]
 *         {
 *             new Aws.Amplify.Inputs.DomainAssociationSubDomainArgs
 *             {
 *                 BranchName = master.BranchName,
 *                 Prefix = "",
 *             },
 *             new Aws.Amplify.Inputs.DomainAssociationSubDomainArgs
 *             {
 *                 BranchName = master.BranchName,
 *                 Prefix = "www",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("app"),
 * 			CustomRules: amplify.AppCustomRuleArray{
 * 				&amplify.AppCustomRuleArgs{
 * 					Source: pulumi.String("https://example.com"),
 * 					Status: pulumi.String("302"),
 * 					Target: pulumi.String("https://www.example.com"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		master, err := amplify.NewBranch(ctx, "master", &amplify.BranchArgs{
 * 			AppId:      example.ID(),
 * 			BranchName: pulumi.String("master"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amplify.NewDomainAssociation(ctx, "example", &amplify.DomainAssociationArgs{
 * 			AppId:      example.ID(),
 * 			DomainName: pulumi.String("example.com"),
 * 			SubDomains: amplify.DomainAssociationSubDomainArray{
 * 				&amplify.DomainAssociationSubDomainArgs{
 * 					BranchName: master.BranchName,
 * 					Prefix:     pulumi.String(""),
 * 				},
 * 				&amplify.DomainAssociationSubDomainArgs{
 * 					BranchName: master.BranchName,
 * 					Prefix:     pulumi.String("www"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.amplify.DomainAssociation;
 * import com.pulumi.aws.amplify.DomainAssociationArgs;
 * import com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("app")
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source("https://example.com")
 *                 .status("302")
 *                 .target("https://www.example.com")
 *                 .build())
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .build());
 *         var exampleDomainAssociation = new DomainAssociation("exampleDomainAssociation", DomainAssociationArgs.builder()
 *             .appId(example.id())
 *             .domainName("example.com")
 *             .subDomains(
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix("")
 *                     .build(),
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix("www")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: app
 *       customRules:
 *         - source: https://example.com
 *           status: '302'
 *           target: https://www.example.com
 *   master:
 *     type: aws:amplify:Branch
 *     properties:
 *       appId: ${example.id}
 *       branchName: master
 *   exampleDomainAssociation:
 *     type: aws:amplify:DomainAssociation
 *     name: example
 *     properties:
 *       appId: ${example.id}
 *       domainName: example.com
 *       subDomains:
 *         - branchName: ${master.branchName}
 *           prefix:
 *         - branchName: ${master.branchName}
 *           prefix: www
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amplify domain association using `app_id` and `domain_name`. For example:
 * ```sh
 * $ pulumi import aws:amplify/domainAssociation:DomainAssociation app d2ypk4k47z8u6/example.com
 * ```
 * @property appId Unique ID for an Amplify app.
 * @property certificateSettings The type of SSL/TLS certificate to use for your custom domain. If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
 * @property domainName Domain name for the domain association.
 * @property enableAutoSubDomain Enables the automated creation of subdomains for branches.
 * @property subDomains Setting for the subdomain. Documented below.
 * @property waitForVerification If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
 */
public data class DomainAssociationArgs(
    public val appId: Output<String>? = null,
    public val certificateSettings: Output<DomainAssociationCertificateSettingsArgs>? = null,
    public val domainName: Output<String>? = null,
    public val enableAutoSubDomain: Output<Boolean>? = null,
    public val subDomains: Output<List<DomainAssociationSubDomainArgs>>? = null,
    public val waitForVerification: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.DomainAssociationArgs> {
    override fun toJava(): com.pulumi.aws.amplify.DomainAssociationArgs =
        com.pulumi.aws.amplify.DomainAssociationArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .certificateSettings(
                certificateSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .enableAutoSubDomain(enableAutoSubDomain?.applyValue({ args0 -> args0 }))
            .subDomains(
                subDomains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .waitForVerification(waitForVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAssociationArgs].
 */
@PulumiTagMarker
public class DomainAssociationArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var certificateSettings: Output<DomainAssociationCertificateSettingsArgs>? = null

    private var domainName: Output<String>? = null

    private var enableAutoSubDomain: Output<Boolean>? = null

    private var subDomains: Output<List<DomainAssociationSubDomainArgs>>? = null

    private var waitForVerification: Output<Boolean>? = null

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("otqsmehldctfbntg")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value The type of SSL/TLS certificate to use for your custom domain. If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
     */
    @JvmName("thudvwpntptepsmf")
    public suspend fun certificateSettings(`value`: Output<DomainAssociationCertificateSettingsArgs>) {
        this.certificateSettings = value
    }

    /**
     * @param value Domain name for the domain association.
     */
    @JvmName("nsqpjgycbcohascl")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Enables the automated creation of subdomains for branches.
     */
    @JvmName("bfsussrjbcedifaf")
    public suspend fun enableAutoSubDomain(`value`: Output<Boolean>) {
        this.enableAutoSubDomain = value
    }

    /**
     * @param value Setting for the subdomain. Documented below.
     */
    @JvmName("lvvjqgxuxgadnmcu")
    public suspend fun subDomains(`value`: Output<List<DomainAssociationSubDomainArgs>>) {
        this.subDomains = value
    }

    @JvmName("uuspipdsascdglco")
    public suspend fun subDomains(vararg values: Output<DomainAssociationSubDomainArgs>) {
        this.subDomains = Output.all(values.asList())
    }

    /**
     * @param values Setting for the subdomain. Documented below.
     */
    @JvmName("bhqurcrmactuogua")
    public suspend fun subDomains(values: List<Output<DomainAssociationSubDomainArgs>>) {
        this.subDomains = Output.all(values)
    }

    /**
     * @param value If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("ummiuebdyvgptudr")
    public suspend fun waitForVerification(`value`: Output<Boolean>) {
        this.waitForVerification = value
    }

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("pdbyqysaqxbbstyj")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value The type of SSL/TLS certificate to use for your custom domain. If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
     */
    @JvmName("ffkwlwoodchdnxwg")
    public suspend fun certificateSettings(`value`: DomainAssociationCertificateSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSettings = mapped
    }

    /**
     * @param argument The type of SSL/TLS certificate to use for your custom domain. If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
     */
    @JvmName("ohjpqyibvsllckat")
    public suspend fun certificateSettings(argument: suspend DomainAssociationCertificateSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainAssociationCertificateSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.certificateSettings = mapped
    }

    /**
     * @param value Domain name for the domain association.
     */
    @JvmName("yfscxcnvqfchlvms")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Enables the automated creation of subdomains for branches.
     */
    @JvmName("qewbhrwxnasvprvx")
    public suspend fun enableAutoSubDomain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoSubDomain = mapped
    }

    /**
     * @param value Setting for the subdomain. Documented below.
     */
    @JvmName("rruujvldwipjhpfk")
    public suspend fun subDomains(`value`: List<DomainAssociationSubDomainArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomains = mapped
    }

    /**
     * @param argument Setting for the subdomain. Documented below.
     */
    @JvmName("gfpgdlltbtnnijnr")
    public suspend fun subDomains(argument: List<suspend DomainAssociationSubDomainArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainAssociationSubDomainArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subDomains = mapped
    }

    /**
     * @param argument Setting for the subdomain. Documented below.
     */
    @JvmName("ffcijysaypdrugob")
    public suspend fun subDomains(vararg argument: suspend DomainAssociationSubDomainArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainAssociationSubDomainArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subDomains = mapped
    }

    /**
     * @param argument Setting for the subdomain. Documented below.
     */
    @JvmName("ounmodxxqunkpwsk")
    public suspend fun subDomains(argument: suspend DomainAssociationSubDomainArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainAssociationSubDomainArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subDomains = mapped
    }

    /**
     * @param values Setting for the subdomain. Documented below.
     */
    @JvmName("hltjugchvxxhgsan")
    public suspend fun subDomains(vararg values: DomainAssociationSubDomainArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subDomains = mapped
    }

    /**
     * @param value If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("weampmdexwwsmpyn")
    public suspend fun waitForVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForVerification = mapped
    }

    internal fun build(): DomainAssociationArgs = DomainAssociationArgs(
        appId = appId,
        certificateSettings = certificateSettings,
        domainName = domainName,
        enableAutoSubDomain = enableAutoSubDomain,
        subDomains = subDomains,
        waitForVerification = waitForVerification,
    )
}
