@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Webhook].
 */
@PulumiTagMarker
public class WebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebhookArgs = WebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebhookArgsBuilder.() -> Unit) {
        val builder = WebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Webhook {
        val builtJavaResource = com.pulumi.aws.amplify.Webhook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Webhook(builtJavaResource)
    }
}

/**
 * Provides an Amplify Webhook resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.amplify.App("example", {name: "app"});
 * const master = new aws.amplify.Branch("master", {
 *     appId: example.id,
 *     branchName: "master",
 * });
 * const masterWebhook = new aws.amplify.Webhook("master", {
 *     appId: example.id,
 *     branchName: master.branchName,
 *     description: "triggermaster",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.amplify.App("example", name="app")
 * master = aws.amplify.Branch("master",
 *     app_id=example.id,
 *     branch_name="master")
 * master_webhook = aws.amplify.Webhook("master",
 *     app_id=example.id,
 *     branch_name=master.branch_name,
 *     description="triggermaster")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Amplify.App("example", new()
 *     {
 *         Name = "app",
 *     });
 *     var master = new Aws.Amplify.Branch("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = "master",
 *     });
 *     var masterWebhook = new Aws.Amplify.Webhook("master", new()
 *     {
 *         AppId = example.Id,
 *         BranchName = master.BranchName,
 *         Description = "triggermaster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/amplify"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := amplify.NewApp(ctx, "example", &amplify.AppArgs{
 * 			Name: pulumi.String("app"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		master, err := amplify.NewBranch(ctx, "master", &amplify.BranchArgs{
 * 			AppId:      example.ID(),
 * 			BranchName: pulumi.String("master"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = amplify.NewWebhook(ctx, "master", &amplify.WebhookArgs{
 * 			AppId:       example.ID(),
 * 			BranchName:  master.BranchName,
 * 			Description: pulumi.String("triggermaster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.amplify.Webhook;
 * import com.pulumi.aws.amplify.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .name("app")
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .build());
 *         var masterWebhook = new Webhook("masterWebhook", WebhookArgs.builder()
 *             .appId(example.id())
 *             .branchName(master.branchName())
 *             .description("triggermaster")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:amplify:App
 *     properties:
 *       name: app
 *   master:
 *     type: aws:amplify:Branch
 *     properties:
 *       appId: ${example.id}
 *       branchName: master
 *   masterWebhook:
 *     type: aws:amplify:Webhook
 *     name: master
 *     properties:
 *       appId: ${example.id}
 *       branchName: ${master.branchName}
 *       description: triggermaster
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amplify webhook using a webhook ID. For example:
 * ```sh
 * $ pulumi import aws:amplify/webhook:Webhook master a26b22a0-748b-4b57-b9a0-ae7e601fe4b1
 * ```
 */
public class Webhook internal constructor(
    override val javaResource: com.pulumi.aws.amplify.Webhook,
) : KotlinCustomResource(javaResource, WebhookMapper) {
    /**
     * Unique ID for an Amplify app.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * ARN for the webhook.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name for a branch that is part of the Amplify app.
     */
    public val branchName: Output<String>
        get() = javaResource.branchName().applyValue({ args0 -> args0 })

    /**
     * Description for a webhook.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URL of the webhook.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object WebhookMapper : ResourceMapper<Webhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amplify.Webhook::class == javaResource::class

    override fun map(javaResource: Resource): Webhook = Webhook(
        javaResource as
            com.pulumi.aws.amplify.Webhook,
    )
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Webhook].
 */
public suspend fun webhook(name: String, block: suspend WebhookResourceBuilder.() -> Unit): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webhook(name: String): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
