@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.inputs

import com.pulumi.aws.amplify.inputs.DomainAssociationCertificateSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateVerificationDnsRecord DNS records for certificate verification in a space-delimited format (`<record> CNAME <target>`).
 * @property customCertificateArn The Amazon resource name (ARN) for the custom certificate.
 * @property type The certificate type. Valid values are `AMPLIFY_MANAGED` and `CUSTOM`.
 */
public data class DomainAssociationCertificateSettingsArgs(
    public val certificateVerificationDnsRecord: Output<String>? = null,
    public val customCertificateArn: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.amplify.inputs.DomainAssociationCertificateSettingsArgs> {
    override fun toJava(): com.pulumi.aws.amplify.inputs.DomainAssociationCertificateSettingsArgs =
        com.pulumi.aws.amplify.inputs.DomainAssociationCertificateSettingsArgs.builder()
            .certificateVerificationDnsRecord(certificateVerificationDnsRecord?.applyValue({ args0 -> args0 }))
            .customCertificateArn(customCertificateArn?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAssociationCertificateSettingsArgs].
 */
@PulumiTagMarker
public class DomainAssociationCertificateSettingsArgsBuilder internal constructor() {
    private var certificateVerificationDnsRecord: Output<String>? = null

    private var customCertificateArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value DNS records for certificate verification in a space-delimited format (`<record> CNAME <target>`).
     */
    @JvmName("rriigfxvdwyqvaae")
    public suspend fun certificateVerificationDnsRecord(`value`: Output<String>) {
        this.certificateVerificationDnsRecord = value
    }

    /**
     * @param value The Amazon resource name (ARN) for the custom certificate.
     */
    @JvmName("ypdgcseygcrmvkdj")
    public suspend fun customCertificateArn(`value`: Output<String>) {
        this.customCertificateArn = value
    }

    /**
     * @param value The certificate type. Valid values are `AMPLIFY_MANAGED` and `CUSTOM`.
     */
    @JvmName("lklqpajycvhumpja")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value DNS records for certificate verification in a space-delimited format (`<record> CNAME <target>`).
     */
    @JvmName("ribdwxgjtyrxxamg")
    public suspend fun certificateVerificationDnsRecord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateVerificationDnsRecord = mapped
    }

    /**
     * @param value The Amazon resource name (ARN) for the custom certificate.
     */
    @JvmName("frsorktifyejkuqc")
    public suspend fun customCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCertificateArn = mapped
    }

    /**
     * @param value The certificate type. Valid values are `AMPLIFY_MANAGED` and `CUSTOM`.
     */
    @JvmName("gdqmmkeubnseddam")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DomainAssociationCertificateSettingsArgs =
        DomainAssociationCertificateSettingsArgs(
            certificateVerificationDnsRecord = certificateVerificationDnsRecord,
            customCertificateArn = customCertificateArn,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
