@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateVerificationDnsRecord DNS records for certificate verification in a space-delimited format (`<record> CNAME <target>`).
 * @property customCertificateArn The Amazon resource name (ARN) for the custom certificate.
 * @property type The certificate type. Valid values are `AMPLIFY_MANAGED` and `CUSTOM`.
 */
public data class DomainAssociationCertificateSettings(
    public val certificateVerificationDnsRecord: String? = null,
    public val customCertificateArn: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amplify.outputs.DomainAssociationCertificateSettings): DomainAssociationCertificateSettings = DomainAssociationCertificateSettings(
            certificateVerificationDnsRecord = javaType.certificateVerificationDnsRecord().map({ args0 ->
                args0
            }).orElse(null),
            customCertificateArn = javaType.customCertificateArn().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
