@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.AccountThrottleSetting
import com.pulumi.aws.apigateway.kotlin.outputs.AccountThrottleSetting.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.aws.apigateway.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Provides a settings of an API Gateway Account. Settings is applied region-wide per `provider` block.
 * > **Note:** As there is no API method for deleting account settings or resetting it to defaults, destroying this resource will keep your account settings intact
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["apigateway&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const cloudwatchRole = new aws.iam.Role("cloudwatch", {
 *     name: "api_gateway_cloudwatch_global",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const demo = new aws.apigateway.Account("demo", {cloudwatchRoleArn: cloudwatchRole.arn});
 * const cloudwatch = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: [
 *             "logs:CreateLogGroup",
 *             "logs:CreateLogStream",
 *             "logs:DescribeLogGroups",
 *             "logs:DescribeLogStreams",
 *             "logs:PutLogEvents",
 *             "logs:GetLogEvents",
 *             "logs:FilterLogEvents",
 *         ],
 *         resources: ["*"],
 *     }],
 * });
 * const cloudwatchRolePolicy = new aws.iam.RolePolicy("cloudwatch", {
 *     name: "default",
 *     role: cloudwatchRole.id,
 *     policy: cloudwatch.then(cloudwatch => cloudwatch.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["apigateway&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * cloudwatch_role = aws.iam.Role("cloudwatch",
 *     name="api_gateway_cloudwatch_global",
 *     assume_role_policy=assume_role.json)
 * demo = aws.apigateway.Account("demo", cloudwatch_role_arn=cloudwatch_role.arn)
 * cloudwatch = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": [
 *         "logs:CreateLogGroup",
 *         "logs:CreateLogStream",
 *         "logs:DescribeLogGroups",
 *         "logs:DescribeLogStreams",
 *         "logs:PutLogEvents",
 *         "logs:GetLogEvents",
 *         "logs:FilterLogEvents",
 *     ],
 *     "resources": ["*"],
 * }])
 * cloudwatch_role_policy = aws.iam.RolePolicy("cloudwatch",
 *     name="default",
 *     role=cloudwatch_role.id,
 *     policy=cloudwatch.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "apigateway.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var cloudwatchRole = new Aws.Iam.Role("cloudwatch", new()
 *     {
 *         Name = "api_gateway_cloudwatch_global",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var demo = new Aws.ApiGateway.Account("demo", new()
 *     {
 *         CloudwatchRoleArn = cloudwatchRole.Arn,
 *     });
 *     var cloudwatch = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:DescribeLogGroups",
 *                     "logs:DescribeLogStreams",
 *                     "logs:PutLogEvents",
 *                     "logs:GetLogEvents",
 *                     "logs:FilterLogEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var cloudwatchRolePolicy = new Aws.Iam.RolePolicy("cloudwatch", new()
 *     {
 *         Name = "default",
 *         Role = cloudwatchRole.Id,
 *         Policy = cloudwatch.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"apigateway.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cloudwatchRole, err := iam.NewRole(ctx, "cloudwatch", &iam.RoleArgs{
 * 			Name:             pulumi.String("api_gateway_cloudwatch_global"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewAccount(ctx, "demo", &apigateway.AccountArgs{
 * 			CloudwatchRoleArn: cloudwatchRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		cloudwatch, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"logs:CreateLogGroup",
 * 						"logs:CreateLogStream",
 * 						"logs:DescribeLogGroups",
 * 						"logs:DescribeLogStreams",
 * 						"logs:PutLogEvents",
 * 						"logs:GetLogEvents",
 * 						"logs:FilterLogEvents",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicy(ctx, "cloudwatch", &iam.RolePolicyArgs{
 * 			Name:   pulumi.String("default"),
 * 			Role:   cloudwatchRole.ID(),
 * 			Policy: pulumi.String(cloudwatch.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.apigateway.Account;
 * import com.pulumi.aws.apigateway.AccountArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("apigateway.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var cloudwatchRole = new Role("cloudwatchRole", RoleArgs.builder()
 *             .name("api_gateway_cloudwatch_global")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var demo = new Account("demo", AccountArgs.builder()
 *             .cloudwatchRoleArn(cloudwatchRole.arn())
 *             .build());
 *         final var cloudwatch = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:DescribeLogGroups",
 *                     "logs:DescribeLogStreams",
 *                     "logs:PutLogEvents",
 *                     "logs:GetLogEvents",
 *                     "logs:FilterLogEvents")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var cloudwatchRolePolicy = new RolePolicy("cloudwatchRolePolicy", RolePolicyArgs.builder()
 *             .name("default")
 *             .role(cloudwatchRole.id())
 *             .policy(cloudwatch.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   demo:
 *     type: aws:apigateway:Account
 *     properties:
 *       cloudwatchRoleArn: ${cloudwatchRole.arn}
 *   cloudwatchRole:
 *     type: aws:iam:Role
 *     name: cloudwatch
 *     properties:
 *       name: api_gateway_cloudwatch_global
 *       assumeRolePolicy: ${assumeRole.json}
 *   cloudwatchRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: cloudwatch
 *     properties:
 *       name: default
 *       role: ${cloudwatchRole.id}
 *       policy: ${cloudwatch.json}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - apigateway.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   cloudwatch:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - logs:CreateLogGroup
 *               - logs:CreateLogStream
 *               - logs:DescribeLogGroups
 *               - logs:DescribeLogStreams
 *               - logs:PutLogEvents
 *               - logs:GetLogEvents
 *               - logs:FilterLogEvents
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import API Gateway Accounts using the word `api-gateway-account`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/account:Account demo api-gateway-account
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The version of the API keys used for the account.
     */
    public val apiKeyVersion: Output<String>
        get() = javaResource.apiKeyVersion().applyValue({ args0 -> args0 })

    /**
     * ARN of an IAM role for CloudWatch (to allow logging & monitoring). See more [in AWS Docs](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-stage-settings.html#how-to-stage-settings-console). Logging & monitoring can be enabled/disabled and otherwise tuned on the API Gateway Stage level.
     */
    public val cloudwatchRoleArn: Output<String>?
        get() = javaResource.cloudwatchRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of features supported for the account.
     */
    public val features: Output<List<String>>
        get() = javaResource.features().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Account-Level throttle settings. See exported fields below.
     */
    public val throttleSettings: Output<List<AccountThrottleSetting>>
        get() = javaResource.throttleSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.aws.apigateway.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
