@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ApigatewayFunctions.getAuthorizerPlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getAuthorizersPlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getDomainNamePlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getExportPlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getKeyPlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getResourcePlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getRestApiPlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getSdkPlain
import com.pulumi.aws.apigateway.ApigatewayFunctions.getVpcLinkPlain
import com.pulumi.aws.apigateway.kotlin.inputs.GetAuthorizerPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetAuthorizerPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetAuthorizersPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetAuthorizersPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetDomainNamePlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetDomainNamePlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetExportPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetExportPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetKeyPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetKeyPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetResourcePlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetResourcePlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetRestApiPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetRestApiPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetSdkPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetSdkPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.GetVpcLinkPlainArgs
import com.pulumi.aws.apigateway.kotlin.inputs.GetVpcLinkPlainArgsBuilder
import com.pulumi.aws.apigateway.kotlin.outputs.GetAuthorizerResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetAuthorizersResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetDomainNameResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetExportResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetKeyResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetResourceResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetRestApiResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetSdkResult
import com.pulumi.aws.apigateway.kotlin.outputs.GetVpcLinkResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.apigateway.kotlin.outputs.GetAuthorizerResult.Companion.toKotlin as getAuthorizerResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetAuthorizersResult.Companion.toKotlin as getAuthorizersResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetDomainNameResult.Companion.toKotlin as getDomainNameResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetExportResult.Companion.toKotlin as getExportResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetKeyResult.Companion.toKotlin as getKeyResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetResourceResult.Companion.toKotlin as getResourceResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetRestApiResult.Companion.toKotlin as getRestApiResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetSdkResult.Companion.toKotlin as getSdkResultToKotlin
import com.pulumi.aws.apigateway.kotlin.outputs.GetVpcLinkResult.Companion.toKotlin as getVpcLinkResultToKotlin

public object ApigatewayFunctions {
    /**
     * Provides details about a specific API Gateway Authorizer.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.apigateway.getAuthorizer({
     *     restApiId: exampleAwsApiGatewayRestApi.id,
     *     authorizerId: exampleAwsApiGatewayAuthorizers.ids[0],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.apigateway.get_authorizer(rest_api_id=example_aws_api_gateway_rest_api["id"],
     *     authorizer_id=example_aws_api_gateway_authorizers["ids"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ApiGateway.GetAuthorizer.Invoke(new()
     *     {
     *         RestApiId = exampleAwsApiGatewayRestApi.Id,
     *         AuthorizerId = exampleAwsApiGatewayAuthorizers.Ids[0],
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.LookupAuthorizer(ctx, &apigateway.LookupAuthorizerArgs{
     * 			RestApiId:    exampleAwsApiGatewayRestApi.Id,
     * 			AuthorizerId: exampleAwsApiGatewayAuthorizers.Ids[0],
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetAuthorizerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ApigatewayFunctions.getAuthorizer(GetAuthorizerArgs.builder()
     *             .restApiId(exampleAwsApiGatewayRestApi.id())
     *             .authorizerId(exampleAwsApiGatewayAuthorizers.ids()[0])
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:apigateway:getAuthorizer
     *       Arguments:
     *         restApiId: ${exampleAwsApiGatewayRestApi.id}
     *         authorizerId: ${exampleAwsApiGatewayAuthorizers.ids[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAuthorizer.
     * @return A collection of values returned by getAuthorizer.
     */
    public suspend fun getAuthorizer(argument: GetAuthorizerPlainArgs): GetAuthorizerResult =
        getAuthorizerResultToKotlin(getAuthorizerPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizer].
     * @param authorizerId Authorizer identifier.
     * @param restApiId ID of the associated REST API.
     * @return A collection of values returned by getAuthorizer.
     */
    public suspend fun getAuthorizer(authorizerId: String, restApiId: String): GetAuthorizerResult {
        val argument = GetAuthorizerPlainArgs(
            authorizerId = authorizerId,
            restApiId = restApiId,
        )
        return getAuthorizerResultToKotlin(getAuthorizerPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetAuthorizerPlainArgs].
     * @return A collection of values returned by getAuthorizer.
     */
    public suspend fun getAuthorizer(argument: suspend GetAuthorizerPlainArgsBuilder.() -> Unit): GetAuthorizerResult {
        val builder = GetAuthorizerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizerResultToKotlin(getAuthorizerPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about multiple API Gateway Authorizers.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.apigateway.getAuthorizers({
     *     restApiId: exampleAwsApiGatewayRestApi.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.apigateway.get_authorizers(rest_api_id=example_aws_api_gateway_rest_api["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ApiGateway.GetAuthorizers.Invoke(new()
     *     {
     *         RestApiId = exampleAwsApiGatewayRestApi.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.GetAuthorizers(ctx, &apigateway.GetAuthorizersArgs{
     * 			RestApiId: exampleAwsApiGatewayRestApi.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetAuthorizersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ApigatewayFunctions.getAuthorizers(GetAuthorizersArgs.builder()
     *             .restApiId(exampleAwsApiGatewayRestApi.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:apigateway:getAuthorizers
     *       Arguments:
     *         restApiId: ${exampleAwsApiGatewayRestApi.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAuthorizers.
     * @return A collection of values returned by getAuthorizers.
     */
    public suspend fun getAuthorizers(argument: GetAuthorizersPlainArgs): GetAuthorizersResult =
        getAuthorizersResultToKotlin(getAuthorizersPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizers].
     * @param restApiId ID of the associated REST API.
     * @return A collection of values returned by getAuthorizers.
     */
    public suspend fun getAuthorizers(restApiId: String): GetAuthorizersResult {
        val argument = GetAuthorizersPlainArgs(
            restApiId = restApiId,
        )
        return getAuthorizersResultToKotlin(getAuthorizersPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizers].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetAuthorizersPlainArgs].
     * @return A collection of values returned by getAuthorizers.
     */
    public suspend fun getAuthorizers(argument: suspend GetAuthorizersPlainArgsBuilder.() -> Unit): GetAuthorizersResult {
        val builder = GetAuthorizersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizersResultToKotlin(getAuthorizersPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the custom domain name for use with AWS API Gateway.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.apigateway.getDomainName({
     *     domainName: "api.example.com",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.apigateway.get_domain_name(domain_name="api.example.com")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ApiGateway.GetDomainName.Invoke(new()
     *     {
     *         DomainName = "api.example.com",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.LookupDomainName(ctx, &apigateway.LookupDomainNameArgs{
     * 			DomainName: "api.example.com",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetDomainNameArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ApigatewayFunctions.getDomainName(GetDomainNameArgs.builder()
     *             .domainName("api.example.com")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:apigateway:getDomainName
     *       Arguments:
     *         domainName: api.example.com
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomainName.
     * @return A collection of values returned by getDomainName.
     */
    public suspend fun getDomainName(argument: GetDomainNamePlainArgs): GetDomainNameResult =
        getDomainNameResultToKotlin(getDomainNamePlain(argument.toJava()).await())

    /**
     * @see [getDomainName].
     * @param domainName Fully-qualified domain name to look up. If no domain name is found, an error will be returned.
     * @param tags Key-value map of tags for the resource.
     * @return A collection of values returned by getDomainName.
     */
    public suspend fun getDomainName(domainName: String, tags: Map<String, String>? = null): GetDomainNameResult {
        val argument = GetDomainNamePlainArgs(
            domainName = domainName,
            tags = tags,
        )
        return getDomainNameResultToKotlin(getDomainNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getDomainName].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetDomainNamePlainArgs].
     * @return A collection of values returned by getDomainName.
     */
    public suspend fun getDomainName(argument: suspend GetDomainNamePlainArgsBuilder.() -> Unit): GetDomainNameResult {
        val builder = GetDomainNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainNameResultToKotlin(getDomainNamePlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.apigateway.getExport({
     *     restApiId: exampleAwsApiGatewayStage.restApiId,
     *     stageName: exampleAwsApiGatewayStage.stageName,
     *     exportType: "oas30",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.apigateway.get_export(rest_api_id=example_aws_api_gateway_stage["restApiId"],
     *     stage_name=example_aws_api_gateway_stage["stageName"],
     *     export_type="oas30")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ApiGateway.GetExport.Invoke(new()
     *     {
     *         RestApiId = exampleAwsApiGatewayStage.RestApiId,
     *         StageName = exampleAwsApiGatewayStage.StageName,
     *         ExportType = "oas30",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.GetExport(ctx, &apigateway.GetExportArgs{
     * 			RestApiId:  exampleAwsApiGatewayStage.RestApiId,
     * 			StageName:  exampleAwsApiGatewayStage.StageName,
     * 			ExportType: "oas30",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetExportArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ApigatewayFunctions.getExport(GetExportArgs.builder()
     *             .restApiId(exampleAwsApiGatewayStage.restApiId())
     *             .stageName(exampleAwsApiGatewayStage.stageName())
     *             .exportType("oas30")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:apigateway:getExport
     *       Arguments:
     *         restApiId: ${exampleAwsApiGatewayStage.restApiId}
     *         stageName: ${exampleAwsApiGatewayStage.stageName}
     *         exportType: oas30
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getExport.
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(argument: GetExportPlainArgs): GetExportResult =
        getExportResultToKotlin(getExportPlain(argument.toJava()).await())

    /**
     * @see [getExport].
     * @param accepts Content-type of the export. Valid values are `application/json` and `application/yaml` are supported for `export_type` `ofoas30` and `swagger`.
     * @param exportType Type of export. Acceptable values are `oas30` for OpenAPI 3.0.x and `swagger` for Swagger/OpenAPI 2.0.
     * @param parameters Key-value map of query string parameters that specify properties of the export. the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions.
     * @param restApiId Identifier of the associated REST API.
     * @param stageName Name of the Stage that will be exported.
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(
        accepts: String? = null,
        exportType: String,
        parameters: Map<String, String>? = null,
        restApiId: String,
        stageName: String,
    ): GetExportResult {
        val argument = GetExportPlainArgs(
            accepts = accepts,
            exportType = exportType,
            parameters = parameters,
            restApiId = restApiId,
            stageName = stageName,
        )
        return getExportResultToKotlin(getExportPlain(argument.toJava()).await())
    }

    /**
     * @see [getExport].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetExportPlainArgs].
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(argument: suspend GetExportPlainArgsBuilder.() -> Unit): GetExportResult {
        val builder = GetExportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExportResultToKotlin(getExportPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the name and value of a pre-existing API Key, for
     * example to supply credentials for a dependency microservice.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const myApiKey = aws.apigateway.getKey({
     *     id: "ru3mpjgse6",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_api_key = aws.apigateway.get_key(id="ru3mpjgse6")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var myApiKey = Aws.ApiGateway.GetKey.Invoke(new()
     *     {
     *         Id = "ru3mpjgse6",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.GetKey(ctx, &apigateway.GetKeyArgs{
     * 			Id: "ru3mpjgse6",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetKeyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var myApiKey = ApigatewayFunctions.getKey(GetKeyArgs.builder()
     *             .id("ru3mpjgse6")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   myApiKey:
     *     fn::invoke:
     *       Function: aws:apigateway:getKey
     *       Arguments:
     *         id: ru3mpjgse6
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKey.
     * @return A collection of values returned by getKey.
     */
    public suspend fun getKey(argument: GetKeyPlainArgs): GetKeyResult =
        getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())

    /**
     * @see [getKey].
     * @param id ID of the API Key to look up.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getKey.
     */
    public suspend fun getKey(id: String, tags: Map<String, String>? = null): GetKeyResult {
        val argument = GetKeyPlainArgs(
            id = id,
            tags = tags,
        )
        return getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getKey].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetKeyPlainArgs].
     * @return A collection of values returned by getKey.
     */
    public suspend fun getKey(argument: suspend GetKeyPlainArgsBuilder.() -> Unit): GetKeyResult {
        val builder = GetKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyResultToKotlin(getKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the id of a Resource in API Gateway.
     * To fetch the Resource, you must provide the REST API id as well as the full path.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const myRestApi = aws.apigateway.getRestApi({
     *     name: "my-rest-api",
     * });
     * const myResource = myRestApi.then(myRestApi => aws.apigateway.getResource({
     *     restApiId: myRestApi.id,
     *     path: "/endpoint/path",
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_rest_api = aws.apigateway.get_rest_api(name="my-rest-api")
     * my_resource = aws.apigateway.get_resource(rest_api_id=my_rest_api.id,
     *     path="/endpoint/path")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var myRestApi = Aws.ApiGateway.GetRestApi.Invoke(new()
     *     {
     *         Name = "my-rest-api",
     *     });
     *     var myResource = Aws.ApiGateway.GetResource.Invoke(new()
     *     {
     *         RestApiId = myRestApi.Apply(getRestApiResult => getRestApiResult.Id),
     *         Path = "/endpoint/path",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		myRestApi, err := apigateway.LookupRestApi(ctx, &apigateway.LookupRestApiArgs{
     * 			Name: "my-rest-api",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = apigateway.LookupResource(ctx, &apigateway.LookupResourceArgs{
     * 			RestApiId: myRestApi.Id,
     * 			Path:      "/endpoint/path",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetRestApiArgs;
     * import com.pulumi.aws.apigateway.inputs.GetResourceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var myRestApi = ApigatewayFunctions.getRestApi(GetRestApiArgs.builder()
     *             .name("my-rest-api")
     *             .build());
     *         final var myResource = ApigatewayFunctions.getResource(GetResourceArgs.builder()
     *             .restApiId(myRestApi.applyValue(getRestApiResult -> getRestApiResult.id()))
     *             .path("/endpoint/path")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   myRestApi:
     *     fn::invoke:
     *       Function: aws:apigateway:getRestApi
     *       Arguments:
     *         name: my-rest-api
     *   myResource:
     *     fn::invoke:
     *       Function: aws:apigateway:getResource
     *       Arguments:
     *         restApiId: ${myRestApi.id}
     *         path: /endpoint/path
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResource.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: GetResourcePlainArgs): GetResourceResult =
        getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())

    /**
     * @see [getResource].
     * @param path Full path of the resource.  If no path is found, an error will be returned.
     * @param restApiId REST API id that owns the resource. If no REST API is found, an error will be returned.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(path: String, restApiId: String): GetResourceResult {
        val argument = GetResourcePlainArgs(
            path = path,
            restApiId = restApiId,
        )
        return getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getResource].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetResourcePlainArgs].
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: suspend GetResourcePlainArgsBuilder.() -> Unit): GetResourceResult {
        val builder = GetResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceResultToKotlin(getResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the id and root_resource_id of a REST API in
     * API Gateway. To fetch the REST API you must provide a name to match against.
     * As there is no unique name constraint on REST APIs this data source will
     * error if there is more than one match.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const myRestApi = aws.apigateway.getRestApi({
     *     name: "my-rest-api",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_rest_api = aws.apigateway.get_rest_api(name="my-rest-api")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var myRestApi = Aws.ApiGateway.GetRestApi.Invoke(new()
     *     {
     *         Name = "my-rest-api",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.LookupRestApi(ctx, &apigateway.LookupRestApiArgs{
     * 			Name: "my-rest-api",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetRestApiArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var myRestApi = ApigatewayFunctions.getRestApi(GetRestApiArgs.builder()
     *             .name("my-rest-api")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   myRestApi:
     *     fn::invoke:
     *       Function: aws:apigateway:getRestApi
     *       Arguments:
     *         name: my-rest-api
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRestApi.
     * @return A collection of values returned by getRestApi.
     */
    public suspend fun getRestApi(argument: GetRestApiPlainArgs): GetRestApiResult =
        getRestApiResultToKotlin(getRestApiPlain(argument.toJava()).await())

    /**
     * @see [getRestApi].
     * @param name Name of the REST API to look up. If no REST API is found with this name, an error will be returned. If multiple REST APIs are found with this name, an error will be returned.
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getRestApi.
     */
    public suspend fun getRestApi(name: String, tags: Map<String, String>? = null): GetRestApiResult {
        val argument = GetRestApiPlainArgs(
            name = name,
            tags = tags,
        )
        return getRestApiResultToKotlin(getRestApiPlain(argument.toJava()).await())
    }

    /**
     * @see [getRestApi].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetRestApiPlainArgs].
     * @return A collection of values returned by getRestApi.
     */
    public suspend fun getRestApi(argument: suspend GetRestApiPlainArgsBuilder.() -> Unit): GetRestApiResult {
        val builder = GetRestApiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRestApiResultToKotlin(getRestApiPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.apigateway.getSdk({
     *     restApiId: exampleAwsApiGatewayStage.restApiId,
     *     stageName: exampleAwsApiGatewayStage.stageName,
     *     sdkType: "android",
     *     parameters: {
     *         groupId: "example",
     *         artifactId: "example",
     *         artifactVersion: "example",
     *         invokerPackage: "example",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.apigateway.get_sdk(rest_api_id=example_aws_api_gateway_stage["restApiId"],
     *     stage_name=example_aws_api_gateway_stage["stageName"],
     *     sdk_type="android",
     *     parameters={
     *         "groupId": "example",
     *         "artifactId": "example",
     *         "artifactVersion": "example",
     *         "invokerPackage": "example",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ApiGateway.GetSdk.Invoke(new()
     *     {
     *         RestApiId = exampleAwsApiGatewayStage.RestApiId,
     *         StageName = exampleAwsApiGatewayStage.StageName,
     *         SdkType = "android",
     *         Parameters =
     *         {
     *             { "groupId", "example" },
     *             { "artifactId", "example" },
     *             { "artifactVersion", "example" },
     *             { "invokerPackage", "example" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.GetSdk(ctx, &apigateway.GetSdkArgs{
     * 			RestApiId: exampleAwsApiGatewayStage.RestApiId,
     * 			StageName: exampleAwsApiGatewayStage.StageName,
     * 			SdkType:   "android",
     * 			Parameters: map[string]interface{}{
     * 				"groupId":         "example",
     * 				"artifactId":      "example",
     * 				"artifactVersion": "example",
     * 				"invokerPackage":  "example",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetSdkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ApigatewayFunctions.getSdk(GetSdkArgs.builder()
     *             .restApiId(exampleAwsApiGatewayStage.restApiId())
     *             .stageName(exampleAwsApiGatewayStage.stageName())
     *             .sdkType("android")
     *             .parameters(Map.ofEntries(
     *                 Map.entry("groupId", "example"),
     *                 Map.entry("artifactId", "example"),
     *                 Map.entry("artifactVersion", "example"),
     *                 Map.entry("invokerPackage", "example")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:apigateway:getSdk
     *       Arguments:
     *         restApiId: ${exampleAwsApiGatewayStage.restApiId}
     *         stageName: ${exampleAwsApiGatewayStage.stageName}
     *         sdkType: android
     *         parameters:
     *           groupId: example
     *           artifactId: example
     *           artifactVersion: example
     *           invokerPackage: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSdk.
     * @return A collection of values returned by getSdk.
     */
    public suspend fun getSdk(argument: GetSdkPlainArgs): GetSdkResult =
        getSdkResultToKotlin(getSdkPlain(argument.toJava()).await())

    /**
     * @see [getSdk].
     * @param parameters Key-value map of query string parameters `sdk_type` properties of the SDK. For SDK Type of `objectivec` or `swift`, a parameter named `classPrefix` is required. For SDK Type of `android`, parameters named `groupId`, `artifactId`, `artifactVersion`, and `invokerPackage` are required. For SDK Type of `java`, parameters named `serviceName` and `javaPackageName` are required.
     * @param restApiId Identifier of the associated REST API.
     * @param sdkType Language for the generated SDK. Currently `java`, `javascript`, `android`, `objectivec` (for iOS), `swift` (for iOS), and `ruby` are supported.
     * @param stageName Name of the Stage that will be exported.
     * @return A collection of values returned by getSdk.
     */
    public suspend fun getSdk(
        parameters: Map<String, String>? = null,
        restApiId: String,
        sdkType: String,
        stageName: String,
    ): GetSdkResult {
        val argument = GetSdkPlainArgs(
            parameters = parameters,
            restApiId = restApiId,
            sdkType = sdkType,
            stageName = stageName,
        )
        return getSdkResultToKotlin(getSdkPlain(argument.toJava()).await())
    }

    /**
     * @see [getSdk].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetSdkPlainArgs].
     * @return A collection of values returned by getSdk.
     */
    public suspend fun getSdk(argument: suspend GetSdkPlainArgsBuilder.() -> Unit): GetSdkResult {
        val builder = GetSdkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSdkResultToKotlin(getSdkPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the id of a VPC Link in
     * API Gateway. To fetch the VPC Link you must provide a name to match against.
     * As there is no unique name constraint on API Gateway VPC Links this data source will
     * error if there is more than one match.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const myApiGatewayVpcLink = aws.apigateway.getVpcLink({
     *     name: "my-vpc-link",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_api_gateway_vpc_link = aws.apigateway.get_vpc_link(name="my-vpc-link")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var myApiGatewayVpcLink = Aws.ApiGateway.GetVpcLink.Invoke(new()
     *     {
     *         Name = "my-vpc-link",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := apigateway.LookupVpcLink(ctx, &apigateway.LookupVpcLinkArgs{
     * 			Name: "my-vpc-link",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigateway.ApigatewayFunctions;
     * import com.pulumi.aws.apigateway.inputs.GetVpcLinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var myApiGatewayVpcLink = ApigatewayFunctions.getVpcLink(GetVpcLinkArgs.builder()
     *             .name("my-vpc-link")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   myApiGatewayVpcLink:
     *     fn::invoke:
     *       Function: aws:apigateway:getVpcLink
     *       Arguments:
     *         name: my-vpc-link
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcLink.
     * @return A collection of values returned by getVpcLink.
     */
    public suspend fun getVpcLink(argument: GetVpcLinkPlainArgs): GetVpcLinkResult =
        getVpcLinkResultToKotlin(getVpcLinkPlain(argument.toJava()).await())

    /**
     * @see [getVpcLink].
     * @param name Name of the API Gateway VPC Link to look up. If no API Gateway VPC Link is found with this name, an error will be returned.
     * If multiple API Gateway VPC Links are found with this name, an error will be returned.
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getVpcLink.
     */
    public suspend fun getVpcLink(name: String, tags: Map<String, String>? = null): GetVpcLinkResult {
        val argument = GetVpcLinkPlainArgs(
            name = name,
            tags = tags,
        )
        return getVpcLinkResultToKotlin(getVpcLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcLink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigateway&#46;kotlin&#46;inputs&#46;GetVpcLinkPlainArgs].
     * @return A collection of values returned by getVpcLink.
     */
    public suspend fun getVpcLink(argument: suspend GetVpcLinkPlainArgsBuilder.() -> Unit): GetVpcLinkResult {
        val builder = GetVpcLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcLinkResultToKotlin(getVpcLinkPlain(builtArgument.toJava()).await())
    }
}
