@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Authorizer].
 */
@PulumiTagMarker
public class AuthorizerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizerArgs = AuthorizerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizerArgsBuilder.() -> Unit) {
        val builder = AuthorizerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Authorizer {
        val builtJavaResource = com.pulumi.aws.apigateway.Authorizer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Authorizer(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Authorizer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const demoRestApi = new aws.apigateway.RestApi("demo", {name: "auth-demo"});
 * const invocationAssumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["apigateway&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const invocationRole = new aws.iam.Role("invocation_role", {
 *     name: "api_gateway_auth_invocation",
 *     path: "/",
 *     assumeRolePolicy: invocationAssumeRole.then(invocationAssumeRole => invocationAssumeRole.json),
 * });
 * const lambdaAssumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["lambda&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const lambda = new aws.iam.Role("lambda", {
 *     name: "demo-lambda",
 *     assumeRolePolicy: lambdaAssumeRole.then(lambdaAssumeRole => lambdaAssumeRole.json),
 * });
 * const authorizer = new aws.lambda.Function("authorizer", {
 *     code: new pulumi.asset.FileArchive("lambda-function.zip"),
 *     name: "api_gateway_authorizer",
 *     role: lambda.arn,
 *     handler: "exports.example",
 *     sourceCodeHash: std.filebase64sha256({
 *         input: "lambda-function.zip",
 *     }).then(invoke => invoke.result),
 * });
 * const demo = new aws.apigateway.Authorizer("demo", {
 *     name: "demo",
 *     restApi: demoRestApi.id,
 *     authorizerUri: authorizer.invokeArn,
 *     authorizerCredentials: invocationRole.arn,
 * });
 * const invocationPolicy = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["lambda:InvokeFunction"],
 *         resources: [authorizer&#46;arn],
 *     }],
 * });
 * const invocationPolicyRolePolicy = new aws.iam.RolePolicy("invocation_policy", {
 *     name: "default",
 *     role: invocationRole.id,
 *     policy: invocationPolicy.apply(invocationPolicy => invocationPolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * demo_rest_api = aws.apigateway.RestApi("demo", name="auth-demo")
 * invocation_assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["apigateway&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * invocation_role = aws.iam.Role("invocation_role",
 *     name="api_gateway_auth_invocation",
 *     path="/",
 *     assume_role_policy=invocation_assume_role.json)
 * lambda_assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["lambda&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * lambda_ = aws.iam.Role("lambda",
 *     name="demo-lambda",
 *     assume_role_policy=lambda_assume_role.json)
 * authorizer = aws.lambda_.Function("authorizer",
 *     code=pulumi.FileArchive("lambda-function.zip"),
 *     name="api_gateway_authorizer",
 *     role=lambda_.arn,
 *     handler="exports.example",
 *     source_code_hash=std.filebase64sha256(input="lambda-function.zip").result)
 * demo = aws.apigateway.Authorizer("demo",
 *     name="demo",
 *     rest_api=demo_rest_api.id,
 *     authorizer_uri=authorizer.invoke_arn,
 *     authorizer_credentials=invocation_role.arn)
 * invocation_policy = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "actions": ["lambda:InvokeFunction"],
 *     "resources": [authorizer&#46;arn],
 * }])
 * invocation_policy_role_policy = aws.iam.RolePolicy("invocation_policy",
 *     name="default",
 *     role=invocation_role.id,
 *     policy=invocation_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var demoRestApi = new Aws.ApiGateway.RestApi("demo", new()
 *     {
 *         Name = "auth-demo",
 *     });
 *     var invocationAssumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "apigateway.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var invocationRole = new Aws.Iam.Role("invocation_role", new()
 *     {
 *         Name = "api_gateway_auth_invocation",
 *         Path = "/",
 *         AssumeRolePolicy = invocationAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var lambdaAssumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "lambda.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var lambda = new Aws.Iam.Role("lambda", new()
 *     {
 *         Name = "demo-lambda",
 *         AssumeRolePolicy = lambdaAssumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var authorizer = new Aws.Lambda.Function("authorizer", new()
 *     {
 *         Code = new FileArchive("lambda-function.zip"),
 *         Name = "api_gateway_authorizer",
 *         Role = lambda.Arn,
 *         Handler = "exports.example",
 *         SourceCodeHash = Std.Filebase64sha256.Invoke(new()
 *         {
 *             Input = "lambda-function.zip",
 *         }).Apply(invoke => invoke.Result),
 *     });
 *     var demo = new Aws.ApiGateway.Authorizer("demo", new()
 *     {
 *         Name = "demo",
 *         RestApi = demoRestApi.Id,
 *         AuthorizerUri = authorizer.InvokeArn,
 *         AuthorizerCredentials = invocationRole.Arn,
 *     });
 *     var invocationPolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "lambda:InvokeFunction",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     authorizer.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var invocationPolicyRolePolicy = new Aws.Iam.RolePolicy("invocation_policy", new()
 *     {
 *         Name = "default",
 *         Role = invocationRole.Id,
 *         Policy = invocationPolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		demoRestApi, err := apigateway.NewRestApi(ctx, "demo", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("auth-demo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invocationAssumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"apigateway.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invocationRole, err := iam.NewRole(ctx, "invocation_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("api_gateway_auth_invocation"),
 * 			Path:             pulumi.String("/"),
 * 			AssumeRolePolicy: pulumi.String(invocationAssumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaAssumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"lambda.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambda, err := iam.NewRole(ctx, "lambda", &iam.RoleArgs{
 * 			Name:             pulumi.String("demo-lambda"),
 * 			AssumeRolePolicy: pulumi.String(lambdaAssumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFilebase64sha256, err := std.Filebase64sha256(ctx, &std.Filebase64sha256Args{
 * 			Input: "lambda-function.zip",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		authorizer, err := lambda.NewFunction(ctx, "authorizer", &lambda.FunctionArgs{
 * 			Code:           pulumi.NewFileArchive("lambda-function.zip"),
 * 			Name:           pulumi.String("api_gateway_authorizer"),
 * 			Role:           lambda.Arn,
 * 			Handler:        pulumi.String("exports.example"),
 * 			SourceCodeHash: pulumi.String(invokeFilebase64sha256.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewAuthorizer(ctx, "demo", &apigateway.AuthorizerArgs{
 * 			Name:                  pulumi.String("demo"),
 * 			RestApi:               demoRestApi.ID(),
 * 			AuthorizerUri:         authorizer.InvokeArn,
 * 			AuthorizerCredentials: invocationRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invocationPolicy := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("lambda:InvokeFunction"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						authorizer.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = iam.NewRolePolicy(ctx, "invocation_policy", &iam.RolePolicyArgs{
 * 			Name: pulumi.String("default"),
 * 			Role: invocationRole.ID(),
 * 			Policy: pulumi.String(invocationPolicy.ApplyT(func(invocationPolicy iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &invocationPolicy.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigateway.Authorizer;
 * import com.pulumi.aws.apigateway.AuthorizerArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demoRestApi = new RestApi("demoRestApi", RestApiArgs.builder()
 *             .name("auth-demo")
 *             .build());
 *         final var invocationAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("apigateway.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var invocationRole = new Role("invocationRole", RoleArgs.builder()
 *             .name("api_gateway_auth_invocation")
 *             .path("/")
 *             .assumeRolePolicy(invocationAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambdaAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var lambda = new Role("lambda", RoleArgs.builder()
 *             .name("demo-lambda")
 *             .assumeRolePolicy(lambdaAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var authorizer = new Function("authorizer", FunctionArgs.builder()
 *             .code(new FileArchive("lambda-function.zip"))
 *             .name("api_gateway_authorizer")
 *             .role(lambda.arn())
 *             .handler("exports.example")
 *             .sourceCodeHash(StdFunctions.filebase64sha256(Filebase64sha256Args.builder()
 *                 .input("lambda-function.zip")
 *                 .build()).result())
 *             .build());
 *         var demo = new Authorizer("demo", AuthorizerArgs.builder()
 *             .name("demo")
 *             .restApi(demoRestApi.id())
 *             .authorizerUri(authorizer.invokeArn())
 *             .authorizerCredentials(invocationRole.arn())
 *             .build());
 *         final var invocationPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("lambda:InvokeFunction")
 *                 .resources(authorizer.arn())
 *                 .build())
 *             .build());
 *         var invocationPolicyRolePolicy = new RolePolicy("invocationPolicyRolePolicy", RolePolicyArgs.builder()
 *             .name("default")
 *             .role(invocationRole.id())
 *             .policy(invocationPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(invocationPolicy -> invocationPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   demo:
 *     type: aws:apigateway:Authorizer
 *     properties:
 *       name: demo
 *       restApi: ${demoRestApi.id}
 *       authorizerUri: ${authorizer.invokeArn}
 *       authorizerCredentials: ${invocationRole.arn}
 *   demoRestApi:
 *     type: aws:apigateway:RestApi
 *     name: demo
 *     properties:
 *       name: auth-demo
 *   invocationRole:
 *     type: aws:iam:Role
 *     name: invocation_role
 *     properties:
 *       name: api_gateway_auth_invocation
 *       path: /
 *       assumeRolePolicy: ${invocationAssumeRole.json}
 *   invocationPolicyRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: invocation_policy
 *     properties:
 *       name: default
 *       role: ${invocationRole.id}
 *       policy: ${invocationPolicy.json}
 *   lambda:
 *     type: aws:iam:Role
 *     properties:
 *       name: demo-lambda
 *       assumeRolePolicy: ${lambdaAssumeRole.json}
 *   authorizer:
 *     type: aws:lambda:Function
 *     properties:
 *       code:
 *         fn::FileArchive: lambda-function.zip
 *       name: api_gateway_authorizer
 *       role: ${lambda.arn}
 *       handler: exports.example
 *       sourceCodeHash:
 *         fn::invoke:
 *           Function: std:filebase64sha256
 *           Arguments:
 *             input: lambda-function.zip
 *           Return: result
 * variables:
 *   invocationAssumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - apigateway.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   invocationPolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - lambda:InvokeFunction
 *             resources:
 *               - ${authorizer.arn}
 *   lambdaAssumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - lambda.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Authorizer using the `REST-API-ID/AUTHORIZER-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/authorizer:Authorizer authorizer 12345abcde/example
 * ```
 */
public class Authorizer internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Authorizer,
) : KotlinCustomResource(javaResource, AuthorizerMapper) {
    /**
     * ARN of the API Gateway Authorizer
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
     */
    public val authorizerCredentials: Output<String>?
        get() = javaResource.authorizerCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TTL of cached authorizer results in seconds. Defaults to `300`.
     */
    public val authorizerResultTtlInSeconds: Output<Int>?
        get() = javaResource.authorizerResultTtlInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authorizer's Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
     * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
     */
    public val authorizerUri: Output<String>?
        get() = javaResource.authorizerUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `"method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName"`
     */
    public val identitySource: Output<String>?
        get() = javaResource.identitySource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn't match, the client receives a 401 Unauthorized response.
     */
    public val identityValidationExpression: Output<String>?
        get() = javaResource.identityValidationExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the authorizer
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     */
    public val providerArns: Output<List<String>>?
        get() = javaResource.providerArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AuthorizerMapper : ResourceMapper<Authorizer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Authorizer::class == javaResource::class

    override fun map(javaResource: Resource): Authorizer = Authorizer(
        javaResource as
            com.pulumi.aws.apigateway.Authorizer,
    )
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authorizer].
 */
public suspend fun authorizer(name: String, block: suspend AuthorizerResourceBuilder.() -> Unit): Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizer(name: String): Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    return builder.build()
}
