@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BasePathMapping].
 */
@PulumiTagMarker
public class BasePathMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BasePathMappingArgs = BasePathMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BasePathMappingArgsBuilder.() -> Unit) {
        val builder = BasePathMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BasePathMapping {
        val builtJavaResource = com.pulumi.aws.apigateway.BasePathMapping(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BasePathMapping(builtJavaResource)
    }
}

/**
 * Connects a custom domain name registered via `aws.apigateway.DomainName`
 * with a deployed API so that its methods can be called via the
 * custom domain name.
 * ## Import
 * For a non-root `base_path`:
 * Using `pulumi import`, import `aws_api_gateway_base_path_mapping` using the domain name and base path. For example:
 * For an empty `base_path` or, in other words, a root path (`/`):
 * ```sh
 * $ pulumi import aws:apigateway/basePathMapping:BasePathMapping example example.com/
 * ```
 * For a non-root `base_path`:
 * ```sh
 * $ pulumi import aws:apigateway/basePathMapping:BasePathMapping example example.com/base-path
 * ```
 */
public class BasePathMapping internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.BasePathMapping,
) : KotlinCustomResource(javaResource, BasePathMappingMapper) {
    /**
     * Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     */
    public val basePath: Output<String>?
        get() = javaResource.basePath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Already-registered domain name to connect the API to.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * ID of the API to connect.
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     */
    public val stageName: Output<String>?
        get() = javaResource.stageName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BasePathMappingMapper : ResourceMapper<BasePathMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.BasePathMapping::class == javaResource::class

    override fun map(javaResource: Resource): BasePathMapping = BasePathMapping(
        javaResource as
            com.pulumi.aws.apigateway.BasePathMapping,
    )
}

/**
 * @see [BasePathMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BasePathMapping].
 */
public suspend fun basePathMapping(
    name: String,
    block: suspend BasePathMappingResourceBuilder.() -> Unit,
): BasePathMapping {
    val builder = BasePathMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BasePathMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun basePathMapping(name: String): BasePathMapping {
    val builder = BasePathMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
