@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.BasePathMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connects a custom domain name registered via `aws.apigateway.DomainName`
 * with a deployed API so that its methods can be called via the
 * custom domain name.
 * ## Import
 * For a non-root `base_path`:
 * Using `pulumi import`, import `aws_api_gateway_base_path_mapping` using the domain name and base path. For example:
 * For an empty `base_path` or, in other words, a root path (`/`):
 * ```sh
 * $ pulumi import aws:apigateway/basePathMapping:BasePathMapping example example.com/
 * ```
 * For a non-root `base_path`:
 * ```sh
 * $ pulumi import aws:apigateway/basePathMapping:BasePathMapping example example.com/base-path
 * ```
 * @property basePath Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
 * @property domainName Already-registered domain name to connect the API to.
 * @property restApi ID of the API to connect.
 * @property stageName Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
 */
public data class BasePathMappingArgs(
    public val basePath: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val stageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.BasePathMappingArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.BasePathMappingArgs =
        com.pulumi.aws.apigateway.BasePathMappingArgs.builder()
            .basePath(basePath?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .stageName(stageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasePathMappingArgs].
 */
@PulumiTagMarker
public class BasePathMappingArgsBuilder internal constructor() {
    private var basePath: Output<String>? = null

    private var domainName: Output<String>? = null

    private var restApi: Output<String>? = null

    private var stageName: Output<String>? = null

    /**
     * @param value Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     */
    @JvmName("sygtalaopedradcy")
    public suspend fun basePath(`value`: Output<String>) {
        this.basePath = value
    }

    /**
     * @param value Already-registered domain name to connect the API to.
     */
    @JvmName("ypxoojfsrdymexkf")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value ID of the API to connect.
     */
    @JvmName("egcxrscmfkhbpbos")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     */
    @JvmName("ybhuypqtfvdfavrk")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     * @param value Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     */
    @JvmName("jusybytowtmoxtbc")
    public suspend fun basePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePath = mapped
    }

    /**
     * @param value Already-registered domain name to connect the API to.
     */
    @JvmName("mbakehniflmxiigh")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value ID of the API to connect.
     */
    @JvmName("dkavjiorvkkbnvqm")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     */
    @JvmName("kmniffxphchbtbji")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): BasePathMappingArgs = BasePathMappingArgs(
        basePath = basePath,
        domainName = domainName,
        restApi = restApi,
        stageName = stageName,
    )
}
