@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ClientCertificate].
 */
@PulumiTagMarker
public class ClientCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientCertificateArgs = ClientCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientCertificateArgsBuilder.() -> Unit) {
        val builder = ClientCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClientCertificate {
        val builtJavaResource = com.pulumi.aws.apigateway.ClientCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClientCertificate(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Client Certificate.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const demo = new aws.apigateway.ClientCertificate("demo", {description: "My client certificate"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * demo = aws.apigateway.ClientCertificate("demo", description="My client certificate")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var demo = new Aws.ApiGateway.ClientCertificate("demo", new()
 *     {
 *         Description = "My client certificate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewClientCertificate(ctx, "demo", &apigateway.ClientCertificateArgs{
 * 			Description: pulumi.String("My client certificate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.ClientCertificate;
 * import com.pulumi.aws.apigateway.ClientCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demo = new ClientCertificate("demo", ClientCertificateArgs.builder()
 *             .description("My client certificate")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   demo:
 *     type: aws:apigateway:ClientCertificate
 *     properties:
 *       description: My client certificate
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import API Gateway Client Certificates using the id. For example:
 * ```sh
 * $ pulumi import aws:apigateway/clientCertificate:ClientCertificate demo ab1cqe
 * ```
 */
public class ClientCertificate internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.ClientCertificate,
) : KotlinCustomResource(javaResource, ClientCertificateMapper) {
    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date when the client certificate was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Description of the client certificate.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date when the client certificate will expire.
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * The PEM-encoded public key of the client certificate.
     */
    public val pemEncodedCertificate: Output<String>
        get() = javaResource.pemEncodedCertificate().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClientCertificateMapper : ResourceMapper<ClientCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.ClientCertificate::class == javaResource::class

    override fun map(javaResource: Resource): ClientCertificate = ClientCertificate(
        javaResource as
            com.pulumi.aws.apigateway.ClientCertificate,
    )
}

/**
 * @see [ClientCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClientCertificate].
 */
public suspend fun clientCertificate(
    name: String,
    block: suspend ClientCertificateResourceBuilder.() -> Unit,
): ClientCertificate {
    val builder = ClientCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClientCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clientCertificate(name: String): ClientCertificate {
    val builder = ClientCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
