@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.DeploymentArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.DeploymentCanarySettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.DeploymentCanarySettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an API Gateway REST Deployment. A deployment is a snapshot of the REST API configuration. The deployment can then be published to callable endpoints via the `aws.apigateway.Stage` resource and optionally managed further with the `aws.apigateway.BasePathMapping` resource, `aws.apigateway.DomainName` resource, and `aws_api_method_settings` resource. For more information, see the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html).
 * To properly capture all REST API configuration in a deployment, this resource must have dependencies on all prior resources that manage resources/paths, methods, integrations, etc.
 * * For REST APIs that are configured via OpenAPI specification (`aws.apigateway.RestApi` resource `body` argument), no special dependency setup is needed beyond referencing the  `id` attribute of that resource unless additional resources have further customized the REST API.
 * * When the REST API configuration involves other resources (`aws.apigateway.Integration` resource), the dependency setup can be done with implicit resource references in the `triggers` argument or explicit resource references using the [resource `dependsOn` custom option](https://www.pulumi.com/docs/intro/concepts/resources/#dependson). The `triggers` argument should be preferred over `depends_on`, since `depends_on` can only capture dependency ordering and will not cause the resource to recreate (redeploy the REST API) with upstream configuration changes.
 * !> **WARNING:** It is recommended to use the `aws.apigateway.Stage` resource instead of managing an API Gateway Stage via the `stage_name` argument of this resource. When this resource is recreated (REST API redeployment) with the `stage_name` configured, the stage is deleted and recreated. This will cause a temporary service interruption, increase provide plan differences, and can require a second apply to recreate any downstream stage configuration such as associated `aws_api_method_settings` resources.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_deployment` using `REST-API-ID/DEPLOYMENT-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/deployment:Deployment example aabbccddee/1122334
 * ```
 * The `stage_name`, `stage_description`, and `variables` arguments cannot be imported. Use the `aws_api_gateway_stage` resource to import and manage stages.
 * The `triggers` argument cannot be imported.
 * @property canarySettings Input configuration for the canary deployment when the deployment is a canary release deployment. See `canary_settings below.
 * @property description Description of the deployment
 * @property restApi REST API identifier.
 * @property stageDescription Description to set on the stage managed by the `stage_name` argument.
 * @property stageName Name of the stage to create with this deployment. If the specified stage already exists, it will be updated to point to the new deployment. We recommend using the `aws.apigateway.Stage` resource instead to manage stages.
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger a redeployment.
 * @property variables Map to set on the stage managed by the `stage_name` argument.
 */
public data class DeploymentArgs(
    public val canarySettings: Output<DeploymentCanarySettingsArgs>? = null,
    public val description: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val stageDescription: Output<String>? = null,
    public val stageName: Output<String>? = null,
    public val triggers: Output<Map<String, String>>? = null,
    public val variables: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.DeploymentArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.DeploymentArgs =
        com.pulumi.aws.apigateway.DeploymentArgs.builder()
            .canarySettings(canarySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .stageDescription(stageDescription?.applyValue({ args0 -> args0 }))
            .stageName(stageName?.applyValue({ args0 -> args0 }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var canarySettings: Output<DeploymentCanarySettingsArgs>? = null

    private var description: Output<String>? = null

    private var restApi: Output<String>? = null

    private var stageDescription: Output<String>? = null

    private var stageName: Output<String>? = null

    private var triggers: Output<Map<String, String>>? = null

    private var variables: Output<Map<String, String>>? = null

    /**
     * @param value Input configuration for the canary deployment when the deployment is a canary release deployment. See `canary_settings below.
     */
    @JvmName("ltxxpduldjrifqor")
    public suspend fun canarySettings(`value`: Output<DeploymentCanarySettingsArgs>) {
        this.canarySettings = value
    }

    /**
     * @param value Description of the deployment
     */
    @JvmName("jwmsvjmvmqvgllso")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value REST API identifier.
     */
    @JvmName("itugepfrroxdqvjm")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Description to set on the stage managed by the `stage_name` argument.
     */
    @JvmName("lajeptcjyuvmcxfc")
    public suspend fun stageDescription(`value`: Output<String>) {
        this.stageDescription = value
    }

    /**
     * @param value Name of the stage to create with this deployment. If the specified stage already exists, it will be updated to point to the new deployment. We recommend using the `aws.apigateway.Stage` resource instead to manage stages.
     */
    @JvmName("kbbcsogymsybbmfv")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     */
    @JvmName("kjcsjiryjjvqwvhs")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value Map to set on the stage managed by the `stage_name` argument.
     */
    @JvmName("fyusjxiiiplbpkdo")
    public suspend fun variables(`value`: Output<Map<String, String>>) {
        this.variables = value
    }

    /**
     * @param value Input configuration for the canary deployment when the deployment is a canary release deployment. See `canary_settings below.
     */
    @JvmName("skdimpuqqmnrwcfm")
    public suspend fun canarySettings(`value`: DeploymentCanarySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canarySettings = mapped
    }

    /**
     * @param argument Input configuration for the canary deployment when the deployment is a canary release deployment. See `canary_settings below.
     */
    @JvmName("okdatbdntrqoosjo")
    public suspend fun canarySettings(argument: suspend DeploymentCanarySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentCanarySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.canarySettings = mapped
    }

    /**
     * @param value Description of the deployment
     */
    @JvmName("shdynvkfnohqspgw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value REST API identifier.
     */
    @JvmName("tluiohckwenhbebq")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Description to set on the stage managed by the `stage_name` argument.
     */
    @JvmName("ncrdyfddsvaoglgc")
    public suspend fun stageDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageDescription = mapped
    }

    /**
     * @param value Name of the stage to create with this deployment. If the specified stage already exists, it will be updated to point to the new deployment. We recommend using the `aws.apigateway.Stage` resource instead to manage stages.
     */
    @JvmName("wqekfyonlnaherot")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     */
    @JvmName("bjsvjtjkweyjyxei")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     */
    @JvmName("wtnmobeuvgviceyx")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param value Map to set on the stage managed by the `stage_name` argument.
     */
    @JvmName("rkikbnqhytfenxie")
    public suspend fun variables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param values Map to set on the stage managed by the `stage_name` argument.
     */
    @JvmName("mdkjilnhjiwpvtdb")
    public fun variables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        canarySettings = canarySettings,
        description = description,
        restApi = restApi,
        stageDescription = stageDescription,
        stageName = stageName,
        triggers = triggers,
        variables = variables,
    )
}
