@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.DocumentationPartLocation
import com.pulumi.aws.apigateway.kotlin.outputs.DocumentationPartLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DocumentationPart].
 */
@PulumiTagMarker
public class DocumentationPartResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DocumentationPartArgs = DocumentationPartArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DocumentationPartArgsBuilder.() -> Unit) {
        val builder = DocumentationPartArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DocumentationPart {
        val builtJavaResource = com.pulumi.aws.apigateway.DocumentationPart(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DocumentationPart(builtJavaResource)
    }
}

/**
 * Provides a settings of an API Gateway Documentation Part.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleRestApi = new aws.apigateway.RestApi("example", {name: "example_api"});
 * const example = new aws.apigateway.DocumentationPart("example", {
 *     location: {
 *         type: "METHOD",
 *         method: "GET",
 *         path: "/example",
 *     },
 *     properties: "{\"description\":\"Example description\"}",
 *     restApiId: exampleRestApi.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_rest_api = aws.apigateway.RestApi("example", name="example_api")
 * example = aws.apigateway.DocumentationPart("example",
 *     location={
 *         "type": "METHOD",
 *         "method": "GET",
 *         "path": "/example",
 *     },
 *     properties="{\"description\":\"Example description\"}",
 *     rest_api_id=example_rest_api.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleRestApi = new Aws.ApiGateway.RestApi("example", new()
 *     {
 *         Name = "example_api",
 *     });
 *     var example = new Aws.ApiGateway.DocumentationPart("example", new()
 *     {
 *         Location = new Aws.ApiGateway.Inputs.DocumentationPartLocationArgs
 *         {
 *             Type = "METHOD",
 *             Method = "GET",
 *             Path = "/example",
 *         },
 *         Properties = "{\"description\":\"Example description\"}",
 *         RestApiId = exampleRestApi.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleRestApi, err := apigateway.NewRestApi(ctx, "example", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("example_api"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewDocumentationPart(ctx, "example", &apigateway.DocumentationPartArgs{
 * 			Location: &apigateway.DocumentationPartLocationArgs{
 * 				Type:   pulumi.String("METHOD"),
 * 				Method: pulumi.String("GET"),
 * 				Path:   pulumi.String("/example"),
 * 			},
 * 			Properties: pulumi.String("{\"description\":\"Example description\"}"),
 * 			RestApiId:  exampleRestApi.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.DocumentationPart;
 * import com.pulumi.aws.apigateway.DocumentationPartArgs;
 * import com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .name("example_api")
 *             .build());
 *         var example = new DocumentationPart("example", DocumentationPartArgs.builder()
 *             .location(DocumentationPartLocationArgs.builder()
 *                 .type("METHOD")
 *                 .method("GET")
 *                 .path("/example")
 *                 .build())
 *             .properties("{\"description\":\"Example description\"}")
 *             .restApiId(exampleRestApi.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apigateway:DocumentationPart
 *     properties:
 *       location:
 *         type: METHOD
 *         method: GET
 *         path: /example
 *       properties: '{"description":"Example description"}'
 *       restApiId: ${exampleRestApi.id}
 *   exampleRestApi:
 *     type: aws:apigateway:RestApi
 *     name: example
 *     properties:
 *       name: example_api
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import API Gateway documentation_parts using `REST-API-ID/DOC-PART-ID`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/documentationPart:DocumentationPart example 5i4e1ko720/3oyy3t
 * ```
 */
public class DocumentationPart internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.DocumentationPart,
) : KotlinCustomResource(javaResource, DocumentationPartMapper) {
    /**
     * The DocumentationPart identifier, generated by API Gateway when the documentation part is created.
     */
    public val documentationPartId: Output<String>
        get() = javaResource.documentationPartId().applyValue({ args0 -> args0 })

    /**
     * Location of the targeted API entity of the to-be-created documentation part. See below.
     */
    public val location: Output<DocumentationPartLocation>
        get() = javaResource.location().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }". Only Swagger-compliant key-value pairs can be exported and, hence, published.
     */
    public val properties: Output<String>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * ID of the associated Rest API
     */
    public val restApiId: Output<String>
        get() = javaResource.restApiId().applyValue({ args0 -> args0 })
}

public object DocumentationPartMapper : ResourceMapper<DocumentationPart> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.DocumentationPart::class == javaResource::class

    override fun map(javaResource: Resource): DocumentationPart = DocumentationPart(
        javaResource as
            com.pulumi.aws.apigateway.DocumentationPart,
    )
}

/**
 * @see [DocumentationPart].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DocumentationPart].
 */
public suspend fun documentationPart(
    name: String,
    block: suspend DocumentationPartResourceBuilder.() -> Unit,
): DocumentationPart {
    val builder = DocumentationPartResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DocumentationPart].
 * @param name The _unique_ name of the resulting resource.
 */
public fun documentationPart(name: String): DocumentationPart {
    val builder = DocumentationPartResourceBuilder()
    builder.name(name)
    return builder.build()
}
