@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.IntegrationTlsConfig
import com.pulumi.aws.apigateway.kotlin.outputs.IntegrationTlsConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Integration].
 */
@PulumiTagMarker
public class IntegrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationArgs = IntegrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationArgsBuilder.() -> Unit) {
        val builder = IntegrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Integration {
        val builtJavaResource = com.pulumi.aws.apigateway.Integration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Integration(builtJavaResource)
    }
}

/**
 * Provides an HTTP Method Integration for an API Gateway Integration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDemoAPI = new aws.apigateway.RestApi("MyDemoAPI", {
 *     name: "MyDemoAPI",
 *     description: "This is my API for demonstration purposes",
 * });
 * const myDemoResource = new aws.apigateway.Resource("MyDemoResource", {
 *     restApi: myDemoAPI.id,
 *     parentId: myDemoAPI.rootResourceId,
 *     pathPart: "mydemoresource",
 * });
 * const myDemoMethod = new aws.apigateway.Method("MyDemoMethod", {
 *     restApi: myDemoAPI.id,
 *     resourceId: myDemoResource.id,
 *     httpMethod: "GET",
 *     authorization: "NONE",
 * });
 * const myDemoIntegration = new aws.apigateway.Integration("MyDemoIntegration", {
 *     restApi: myDemoAPI.id,
 *     resourceId: myDemoResource.id,
 *     httpMethod: myDemoMethod.httpMethod,
 *     type: "MOCK",
 *     cacheKeyParameters: ["method&#46;request&#46;path&#46;param"],
 *     cacheNamespace: "foobar",
 *     timeoutMilliseconds: 29000,
 *     requestParameters: {
 *         "integration.request.header.X-Authorization": "'static'",
 *     },
 *     requestTemplates: {
 *         "application/xml": `{
 *    "body" : input.json('')
 * }
 * `,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
 *     name="MyDemoAPI",
 *     description="This is my API for demonstration purposes")
 * my_demo_resource = aws.apigateway.Resource("MyDemoResource",
 *     rest_api=my_demo_api.id,
 *     parent_id=my_demo_api.root_resource_id,
 *     path_part="mydemoresource")
 * my_demo_method = aws.apigateway.Method("MyDemoMethod",
 *     rest_api=my_demo_api.id,
 *     resource_id=my_demo_resource.id,
 *     http_method="GET",
 *     authorization="NONE")
 * my_demo_integration = aws.apigateway.Integration("MyDemoIntegration",
 *     rest_api=my_demo_api.id,
 *     resource_id=my_demo_resource.id,
 *     http_method=my_demo_method.http_method,
 *     type="MOCK",
 *     cache_key_parameters=["method&#46;request&#46;path&#46;param"],
 *     cache_namespace="foobar",
 *     timeout_milliseconds=29000,
 *     request_parameters={
 *         "integration.request.header.X-Authorization": "'static'",
 *     },
 *     request_templates={
 *         "application/xml": """{
 *    "body" : $input.json('$')
 * }
 * """,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDemoAPI = new Aws.ApiGateway.RestApi("MyDemoAPI", new()
 *     {
 *         Name = "MyDemoAPI",
 *         Description = "This is my API for demonstration purposes",
 *     });
 *     var myDemoResource = new Aws.ApiGateway.Resource("MyDemoResource", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ParentId = myDemoAPI.RootResourceId,
 *         PathPart = "mydemoresource",
 *     });
 *     var myDemoMethod = new Aws.ApiGateway.Method("MyDemoMethod", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ResourceId = myDemoResource.Id,
 *         HttpMethod = "GET",
 *         Authorization = "NONE",
 *     });
 *     var myDemoIntegration = new Aws.ApiGateway.Integration("MyDemoIntegration", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ResourceId = myDemoResource.Id,
 *         HttpMethod = myDemoMethod.HttpMethod,
 *         Type = "MOCK",
 *         CacheKeyParameters = new[]
 *         {
 *             "method.request.path.param",
 *         },
 *         CacheNamespace = "foobar",
 *         TimeoutMilliseconds = 29000,
 *         RequestParameters =
 *         {
 *             { "integration.request.header.X-Authorization", "'static'" },
 *         },
 *         RequestTemplates =
 *         {
 *             { "application/xml", @"{
 *    ""body"" : $input.json('$')
 * }
 * " },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDemoAPI, err := apigateway.NewRestApi(ctx, "MyDemoAPI", &apigateway.RestApiArgs{
 * 			Name:        pulumi.String("MyDemoAPI"),
 * 			Description: pulumi.String("This is my API for demonstration purposes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myDemoResource, err := apigateway.NewResource(ctx, "MyDemoResource", &apigateway.ResourceArgs{
 * 			RestApi:  myDemoAPI.ID(),
 * 			ParentId: myDemoAPI.RootResourceId,
 * 			PathPart: pulumi.String("mydemoresource"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myDemoMethod, err := apigateway.NewMethod(ctx, "MyDemoMethod", &apigateway.MethodArgs{
 * 			RestApi:       myDemoAPI.ID(),
 * 			ResourceId:    myDemoResource.ID(),
 * 			HttpMethod:    pulumi.String("GET"),
 * 			Authorization: pulumi.String("NONE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewIntegration(ctx, "MyDemoIntegration", &apigateway.IntegrationArgs{
 * 			RestApi:    myDemoAPI.ID(),
 * 			ResourceId: myDemoResource.ID(),
 * 			HttpMethod: myDemoMethod.HttpMethod,
 * 			Type:       pulumi.String("MOCK"),
 * 			CacheKeyParameters: pulumi.StringArray{
 * 				pulumi.String("method.request.path.param"),
 * 			},
 * 			CacheNamespace:      pulumi.String("foobar"),
 * 			TimeoutMilliseconds: pulumi.Int(29000),
 * 			RequestParameters: pulumi.StringMap{
 * 				"integration.request.header.X-Authorization": pulumi.String("'static'"),
 * 			},
 * 			RequestTemplates: pulumi.StringMap{
 * 				"application/xml": pulumi.String("{\n   \"body\" : $input.json('$')\n}\n"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *         var myDemoMethod = new Method("myDemoMethod", MethodArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .build());
 *         var myDemoIntegration = new Integration("myDemoIntegration", IntegrationArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .type("MOCK")
 *             .cacheKeyParameters("method.request.path.param")
 *             .cacheNamespace("foobar")
 *             .timeoutMilliseconds(29000)
 *             .requestParameters(Map.of("integration.request.header.X-Authorization", "'static'"))
 *             .requestTemplates(Map.of("application/xml", """
 * {
 *    "body" : $input.json('$')
 * }
 *             """))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDemoAPI:
 *     type: aws:apigateway:RestApi
 *     name: MyDemoAPI
 *     properties:
 *       name: MyDemoAPI
 *       description: This is my API for demonstration purposes
 *   myDemoResource:
 *     type: aws:apigateway:Resource
 *     name: MyDemoResource
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       parentId: ${myDemoAPI.rootResourceId}
 *       pathPart: mydemoresource
 *   myDemoMethod:
 *     type: aws:apigateway:Method
 *     name: MyDemoMethod
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       resourceId: ${myDemoResource.id}
 *       httpMethod: GET
 *       authorization: NONE
 *   myDemoIntegration:
 *     type: aws:apigateway:Integration
 *     name: MyDemoIntegration
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       resourceId: ${myDemoResource.id}
 *       httpMethod: ${myDemoMethod.httpMethod}
 *       type: MOCK
 *       cacheKeyParameters:
 *         - method.request.path.param
 *       cacheNamespace: foobar
 *       timeoutMilliseconds: 29000
 *       requestParameters:
 *         integration.request.header.X-Authorization: '''static'''
 *       requestTemplates:
 *         application/xml: |
 *           {
 *              "body" : $input.json('$')
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Lambda integration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const config = new pulumi.Config();
 * const myregion = config.requireObject("myregion");
 * const accountId = config.requireObject("accountId");
 * // API Gateway
 * const api = new aws.apigateway.RestApi("api", {name: "myapi"});
 * const resource = new aws.apigateway.Resource("resource", {
 *     pathPart: "resource",
 *     parentId: api.rootResourceId,
 *     restApi: api.id,
 * });
 * const method = new aws.apigateway.Method("method", {
 *     restApi: api.id,
 *     resourceId: resource.id,
 *     httpMethod: "GET",
 *     authorization: "NONE",
 * });
 * // IAM
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["lambda&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const role = new aws.iam.Role("role", {
 *     name: "myrole",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const lambda = new aws.lambda.Function("lambda", {
 *     code: new pulumi.asset.FileArchive("lambda.zip"),
 *     name: "mylambda",
 *     role: role.arn,
 *     handler: "lambda.lambda_handler",
 *     runtime: aws.lambda.Runtime.Python3d7,
 *     sourceCodeHash: std.filebase64sha256({
 *         input: "lambda.zip",
 *     }).then(invoke => invoke.result),
 * });
 * const integration = new aws.apigateway.Integration("integration", {
 *     restApi: api.id,
 *     resourceId: resource.id,
 *     httpMethod: method.httpMethod,
 *     integrationHttpMethod: "POST",
 *     type: "AWS_PROXY",
 *     uri: lambda.invokeArn,
 * });
 * // Lambda
 * const apigwLambda = new aws.lambda.Permission("apigw_lambda", {
 *     statementId: "AllowExecutionFromAPIGateway",
 *     action: "lambda:InvokeFunction",
 *     "function": lambda.name,
 *     principal: "apigateway.amazonaws.com",
 *     sourceArn: pulumi.interpolate`arn:aws:execute-api:${myregion}:${accountId}:${api.id}/*/${method.httpMethod}${resource.path}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * config = pulumi.Config()
 * myregion = config.require_object("myregion")
 * account_id = config.require_object("accountId")
 * # API Gateway
 * api = aws.apigateway.RestApi("api", name="myapi")
 * resource = aws.apigateway.Resource("resource",
 *     path_part="resource",
 *     parent_id=api.root_resource_id,
 *     rest_api=api.id)
 * method = aws.apigateway.Method("method",
 *     rest_api=api.id,
 *     resource_id=resource.id,
 *     http_method="GET",
 *     authorization="NONE")
 * # IAM
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["lambda&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * role = aws.iam.Role("role",
 *     name="myrole",
 *     assume_role_policy=assume_role.json)
 * lambda_ = aws.lambda_.Function("lambda",
 *     code=pulumi.FileArchive("lambda.zip"),
 *     name="mylambda",
 *     role=role.arn,
 *     handler="lambda.lambda_handler",
 *     runtime=aws.lambda_.Runtime.PYTHON3D7,
 *     source_code_hash=std.filebase64sha256(input="lambda.zip").result)
 * integration = aws.apigateway.Integration("integration",
 *     rest_api=api.id,
 *     resource_id=resource.id,
 *     http_method=method.http_method,
 *     integration_http_method="POST",
 *     type="AWS_PROXY",
 *     uri=lambda_.invoke_arn)
 * # Lambda
 * apigw_lambda = aws.lambda_.Permission("apigw_lambda",
 *     statement_id="AllowExecutionFromAPIGateway",
 *     action="lambda:InvokeFunction",
 *     function=lambda_.name,
 *     principal="apigateway.amazonaws.com",
 *     source_arn=pulumi.Output.all(api.id, method.http_method, resource.path).apply(lambda id, http_method, path: f"arn:aws:execute-api:{myregion}:{account_id}:{id}/*/{http_method}{path}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var myregion = config.RequireObject<dynamic>("myregion");
 *     var accountId = config.RequireObject<dynamic>("accountId");
 *     // API Gateway
 *     var api = new Aws.ApiGateway.RestApi("api", new()
 *     {
 *         Name = "myapi",
 *     });
 *     var resource = new Aws.ApiGateway.Resource("resource", new()
 *     {
 *         PathPart = "resource",
 *         ParentId = api.RootResourceId,
 *         RestApi = api.Id,
 *     });
 *     var method = new Aws.ApiGateway.Method("method", new()
 *     {
 *         RestApi = api.Id,
 *         ResourceId = resource.Id,
 *         HttpMethod = "GET",
 *         Authorization = "NONE",
 *     });
 *     // IAM
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "lambda.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var role = new Aws.Iam.Role("role", new()
 *     {
 *         Name = "myrole",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var lambda = new Aws.Lambda.Function("lambda", new()
 *     {
 *         Code = new FileArchive("lambda.zip"),
 *         Name = "mylambda",
 *         Role = role.Arn,
 *         Handler = "lambda.lambda_handler",
 *         Runtime = Aws.Lambda.Runtime.Python3d7,
 *         SourceCodeHash = Std.Filebase64sha256.Invoke(new()
 *         {
 *             Input = "lambda.zip",
 *         }).Apply(invoke => invoke.Result),
 *     });
 *     var integration = new Aws.ApiGateway.Integration("integration", new()
 *     {
 *         RestApi = api.Id,
 *         ResourceId = resource.Id,
 *         HttpMethod = method.HttpMethod,
 *         IntegrationHttpMethod = "POST",
 *         Type = "AWS_PROXY",
 *         Uri = lambda.InvokeArn,
 *     });
 *     // Lambda
 *     var apigwLambda = new Aws.Lambda.Permission("apigw_lambda", new()
 *     {
 *         StatementId = "AllowExecutionFromAPIGateway",
 *         Action = "lambda:InvokeFunction",
 *         Function = lambda.Name,
 *         Principal = "apigateway.amazonaws.com",
 *         SourceArn = Output.Tuple(api.Id, method.HttpMethod, resource.Path).Apply(values =>
 *         {
 *             var id = values.Item1;
 *             var httpMethod = values.Item2;
 *             var path = values.Item3;
 *             return $"arn:aws:execute-api:{myregion}:{accountId}:{id}/*/{httpMethod}{path}";
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		myregion := cfg.RequireObject("myregion")
 * 		accountId := cfg.RequireObject("accountId")
 * 		// API Gateway
 * 		api, err := apigateway.NewRestApi(ctx, "api", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("myapi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		resource, err := apigateway.NewResource(ctx, "resource", &apigateway.ResourceArgs{
 * 			PathPart: pulumi.String("resource"),
 * 			ParentId: api.RootResourceId,
 * 			RestApi:  api.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		method, err := apigateway.NewMethod(ctx, "method", &apigateway.MethodArgs{
 * 			RestApi:       api.ID(),
 * 			ResourceId:    resource.ID(),
 * 			HttpMethod:    pulumi.String("GET"),
 * 			Authorization: pulumi.String("NONE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// IAM
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"lambda.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		role, err := iam.NewRole(ctx, "role", &iam.RoleArgs{
 * 			Name:             pulumi.String("myrole"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFilebase64sha256, err := std.Filebase64sha256(ctx, &std.Filebase64sha256Args{
 * 			Input: "lambda.zip",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambda, err := lambda.NewFunction(ctx, "lambda", &lambda.FunctionArgs{
 * 			Code:           pulumi.NewFileArchive("lambda.zip"),
 * 			Name:           pulumi.String("mylambda"),
 * 			Role:           role.Arn,
 * 			Handler:        pulumi.String("lambda.lambda_handler"),
 * 			Runtime:        pulumi.String(lambda.RuntimePython3d7),
 * 			SourceCodeHash: pulumi.String(invokeFilebase64sha256.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewIntegration(ctx, "integration", &apigateway.IntegrationArgs{
 * 			RestApi:               api.ID(),
 * 			ResourceId:            resource.ID(),
 * 			HttpMethod:            method.HttpMethod,
 * 			IntegrationHttpMethod: pulumi.String("POST"),
 * 			Type:                  pulumi.String("AWS_PROXY"),
 * 			Uri:                   lambda.InvokeArn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Lambda
 * 		_, err = lambda.NewPermission(ctx, "apigw_lambda", &lambda.PermissionArgs{
 * 			StatementId: pulumi.String("AllowExecutionFromAPIGateway"),
 * 			Action:      pulumi.String("lambda:InvokeFunction"),
 * 			Function:    lambda.Name,
 * 			Principal:   pulumi.String("apigateway.amazonaws.com"),
 * 			SourceArn: pulumi.All(api.ID(), method.HttpMethod, resource.Path).ApplyT(func(_args []interface{}) (string, error) {
 * 				id := _args[0].(string)
 * 				httpMethod := _args[1].(string)
 * 				path := _args[2].(string)
 * 				return fmt.Sprintf("arn:aws:execute-api:%v:%v:%v/*/%v%v", myregion, accountId, id, httpMethod, path), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var myregion = config.get("myregion");
 *         final var accountId = config.get("accountId");
 *         // API Gateway
 *         var api = new RestApi("api", RestApiArgs.builder()
 *             .name("myapi")
 *             .build());
 *         var resource = new Resource("resource", ResourceArgs.builder()
 *             .pathPart("resource")
 *             .parentId(api.rootResourceId())
 *             .restApi(api.id())
 *             .build());
 *         var method = new Method("method", MethodArgs.builder()
 *             .restApi(api.id())
 *             .resourceId(resource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .build());
 *         // IAM
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("myrole")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var lambda = new Function("lambda", FunctionArgs.builder()
 *             .code(new FileArchive("lambda.zip"))
 *             .name("mylambda")
 *             .role(role.arn())
 *             .handler("lambda.lambda_handler")
 *             .runtime("python3.7")
 *             .sourceCodeHash(StdFunctions.filebase64sha256(Filebase64sha256Args.builder()
 *                 .input("lambda.zip")
 *                 .build()).result())
 *             .build());
 *         var integration = new Integration("integration", IntegrationArgs.builder()
 *             .restApi(api.id())
 *             .resourceId(resource.id())
 *             .httpMethod(method.httpMethod())
 *             .integrationHttpMethod("POST")
 *             .type("AWS_PROXY")
 *             .uri(lambda.invokeArn())
 *             .build());
 *         // Lambda
 *         var apigwLambda = new Permission("apigwLambda", PermissionArgs.builder()
 *             .statementId("AllowExecutionFromAPIGateway")
 *             .action("lambda:InvokeFunction")
 *             .function(lambda.name())
 *             .principal("apigateway.amazonaws.com")
 *             .sourceArn(Output.tuple(api.id(), method.httpMethod(), resource.path()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var httpMethod = values.t2;
 *                 var path = values.t3;
 *                 return String.format("arn:aws:execute-api:%s:%s:%s/*/%s%s", myregion,accountId,id,httpMethod,path);
 *             }))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   # Variables
 *   myregion:
 *     type: dynamic
 *   accountId:
 *     type: dynamic
 * resources:
 *   # API Gateway
 *   api:
 *     type: aws:apigateway:RestApi
 *     properties:
 *       name: myapi
 *   resource:
 *     type: aws:apigateway:Resource
 *     properties:
 *       pathPart: resource
 *       parentId: ${api.rootResourceId}
 *       restApi: ${api.id}
 *   method:
 *     type: aws:apigateway:Method
 *     properties:
 *       restApi: ${api.id}
 *       resourceId: ${resource.id}
 *       httpMethod: GET
 *       authorization: NONE
 *   integration:
 *     type: aws:apigateway:Integration
 *     properties:
 *       restApi: ${api.id}
 *       resourceId: ${resource.id}
 *       httpMethod: ${method.httpMethod}
 *       integrationHttpMethod: POST
 *       type: AWS_PROXY
 *       uri: ${lambda.invokeArn}
 *   # Lambda
 *   apigwLambda:
 *     type: aws:lambda:Permission
 *     name: apigw_lambda
 *     properties:
 *       statementId: AllowExecutionFromAPIGateway
 *       action: lambda:InvokeFunction
 *       function: ${lambda.name}
 *       principal: apigateway.amazonaws.com
 *       sourceArn: arn:aws:execute-api:${myregion}:${accountId}:${api.id}/*/${method.httpMethod}${resource.path}
 *   lambda:
 *     type: aws:lambda:Function
 *     properties:
 *       code:
 *         fn::FileArchive: lambda.zip
 *       name: mylambda
 *       role: ${role.arn}
 *       handler: lambda.lambda_handler
 *       runtime: python3.7
 *       sourceCodeHash:
 *         fn::invoke:
 *           Function: std:filebase64sha256
 *           Arguments:
 *             input: lambda.zip
 *           Return: result
 *   role:
 *     type: aws:iam:Role
 *     properties:
 *       name: myrole
 *       assumeRolePolicy: ${assumeRole.json}
 * variables:
 *   # IAM
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - lambda.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## VPC Link
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const config = new pulumi.Config();
 * const name = config.requireObject("name");
 * const subnetId = config.requireObject("subnetId");
 * const test = new aws.lb.LoadBalancer("test", {
 *     name: name,
 *     internal: true,
 *     loadBalancerType: "network",
 *     subnets: [subnetId],
 * });
 * const testVpcLink = new aws.apigateway.VpcLink("test", {
 *     name: name,
 *     targetArn: test.arn,
 * });
 * const testRestApi = new aws.apigateway.RestApi("test", {name: name});
 * const testResource = new aws.apigateway.Resource("test", {
 *     restApi: testRestApi.id,
 *     parentId: testRestApi.rootResourceId,
 *     pathPart: "test",
 * });
 * const testMethod = new aws.apigateway.Method("test", {
 *     restApi: testRestApi.id,
 *     resourceId: testResource.id,
 *     httpMethod: "GET",
 *     authorization: "NONE",
 *     requestModels: {
 *         "application/json": "Error",
 *     },
 * });
 * const testIntegration = new aws.apigateway.Integration("test", {
 *     restApi: testRestApi.id,
 *     resourceId: testResource.id,
 *     httpMethod: testMethod.httpMethod,
 *     requestTemplates: {
 *         "application/json": "",
 *         "application/xml": `#set(inputRoot = input.path(''))
 * { }`,
 *     },
 *     requestParameters: {
 *         "integration.request.header.X-Authorization": "'static'",
 *         "integration.request.header.X-Foo": "'Bar'",
 *     },
 *     type: "HTTP",
 *     uri: "https://www.google.de",
 *     integrationHttpMethod: "GET",
 *     passthroughBehavior: "WHEN_NO_MATCH",
 *     contentHandling: "CONVERT_TO_TEXT",
 *     connectionType: "VPC_LINK",
 *     connectionId: testVpcLink.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * config = pulumi.Config()
 * name = config.require_object("name")
 * subnet_id = config.require_object("subnetId")
 * test = aws.lb.LoadBalancer("test",
 *     name=name,
 *     internal=True,
 *     load_balancer_type="network",
 *     subnets=[subnet_id])
 * test_vpc_link = aws.apigateway.VpcLink("test",
 *     name=name,
 *     target_arn=test.arn)
 * test_rest_api = aws.apigateway.RestApi("test", name=name)
 * test_resource = aws.apigateway.Resource("test",
 *     rest_api=test_rest_api.id,
 *     parent_id=test_rest_api.root_resource_id,
 *     path_part="test")
 * test_method = aws.apigateway.Method("test",
 *     rest_api=test_rest_api.id,
 *     resource_id=test_resource.id,
 *     http_method="GET",
 *     authorization="NONE",
 *     request_models={
 *         "application/json": "Error",
 *     })
 * test_integration = aws.apigateway.Integration("test",
 *     rest_api=test_rest_api.id,
 *     resource_id=test_resource.id,
 *     http_method=test_method.http_method,
 *     request_templates={
 *         "application/json": "",
 *         "application/xml": """#set($inputRoot = $input.path('$'))
 * { }""",
 *     },
 *     request_parameters={
 *         "integration.request.header.X-Authorization": "'static'",
 *         "integration.request.header.X-Foo": "'Bar'",
 *     },
 *     type="HTTP",
 *     uri="https://www.google.de",
 *     integration_http_method="GET",
 *     passthrough_behavior="WHEN_NO_MATCH",
 *     content_handling="CONVERT_TO_TEXT",
 *     connection_type="VPC_LINK",
 *     connection_id=test_vpc_link.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.RequireObject<dynamic>("name");
 *     var subnetId = config.RequireObject<dynamic>("subnetId");
 *     var test = new Aws.LB.LoadBalancer("test", new()
 *     {
 *         Name = name,
 *         Internal = true,
 *         LoadBalancerType = "network",
 *         Subnets = new[]
 *         {
 *             subnetId,
 *         },
 *     });
 *     var testVpcLink = new Aws.ApiGateway.VpcLink("test", new()
 *     {
 *         Name = name,
 *         TargetArn = test.Arn,
 *     });
 *     var testRestApi = new Aws.ApiGateway.RestApi("test", new()
 *     {
 *         Name = name,
 *     });
 *     var testResource = new Aws.ApiGateway.Resource("test", new()
 *     {
 *         RestApi = testRestApi.Id,
 *         ParentId = testRestApi.RootResourceId,
 *         PathPart = "test",
 *     });
 *     var testMethod = new Aws.ApiGateway.Method("test", new()
 *     {
 *         RestApi = testRestApi.Id,
 *         ResourceId = testResource.Id,
 *         HttpMethod = "GET",
 *         Authorization = "NONE",
 *         RequestModels =
 *         {
 *             { "application/json", "Error" },
 *         },
 *     });
 *     var testIntegration = new Aws.ApiGateway.Integration("test", new()
 *     {
 *         RestApi = testRestApi.Id,
 *         ResourceId = testResource.Id,
 *         HttpMethod = testMethod.HttpMethod,
 *         RequestTemplates =
 *         {
 *             { "application/json", "" },
 *             { "application/xml", @"#set($inputRoot = $input.path('$'))
 * { }" },
 *         },
 *         RequestParameters =
 *         {
 *             { "integration.request.header.X-Authorization", "'static'" },
 *             { "integration.request.header.X-Foo", "'Bar'" },
 *         },
 *         Type = "HTTP",
 *         Uri = "https://www.google.de",
 *         IntegrationHttpMethod = "GET",
 *         PassthroughBehavior = "WHEN_NO_MATCH",
 *         ContentHandling = "CONVERT_TO_TEXT",
 *         ConnectionType = "VPC_LINK",
 *         ConnectionId = testVpcLink.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := cfg.RequireObject("name")
 * 		subnetId := cfg.RequireObject("subnetId")
 * 		test, err := lb.NewLoadBalancer(ctx, "test", &lb.LoadBalancerArgs{
 * 			Name:             pulumi.Any(name),
 * 			Internal:         pulumi.Bool(true),
 * 			LoadBalancerType: pulumi.String("network"),
 * 			Subnets: pulumi.StringArray{
 * 				subnetId,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testVpcLink, err := apigateway.NewVpcLink(ctx, "test", &apigateway.VpcLinkArgs{
 * 			Name:      pulumi.Any(name),
 * 			TargetArn: test.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testRestApi, err := apigateway.NewRestApi(ctx, "test", &apigateway.RestApiArgs{
 * 			Name: pulumi.Any(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testResource, err := apigateway.NewResource(ctx, "test", &apigateway.ResourceArgs{
 * 			RestApi:  testRestApi.ID(),
 * 			ParentId: testRestApi.RootResourceId,
 * 			PathPart: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testMethod, err := apigateway.NewMethod(ctx, "test", &apigateway.MethodArgs{
 * 			RestApi:       testRestApi.ID(),
 * 			ResourceId:    testResource.ID(),
 * 			HttpMethod:    pulumi.String("GET"),
 * 			Authorization: pulumi.String("NONE"),
 * 			RequestModels: pulumi.StringMap{
 * 				"application/json": pulumi.String("Error"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewIntegration(ctx, "test", &apigateway.IntegrationArgs{
 * 			RestApi:    testRestApi.ID(),
 * 			ResourceId: testResource.ID(),
 * 			HttpMethod: testMethod.HttpMethod,
 * 			RequestTemplates: pulumi.StringMap{
 * 				"application/json": pulumi.String(""),
 * 				"application/xml":  pulumi.String("#set($inputRoot = $input.path('$'))\n{ }"),
 * 			},
 * 			RequestParameters: pulumi.StringMap{
 * 				"integration.request.header.X-Authorization": pulumi.String("'static'"),
 * 				"integration.request.header.X-Foo":           pulumi.String("'Bar'"),
 * 			},
 * 			Type:                  pulumi.String("HTTP"),
 * 			Uri:                   pulumi.String("https://www.google.de"),
 * 			IntegrationHttpMethod: pulumi.String("GET"),
 * 			PassthroughBehavior:   pulumi.String("WHEN_NO_MATCH"),
 * 			ContentHandling:       pulumi.String("CONVERT_TO_TEXT"),
 * 			ConnectionType:        pulumi.String("VPC_LINK"),
 * 			ConnectionId:          testVpcLink.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.apigateway.VpcLink;
 * import com.pulumi.aws.apigateway.VpcLinkArgs;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name");
 *         final var subnetId = config.get("subnetId");
 *         var test = new LoadBalancer("test", LoadBalancerArgs.builder()
 *             .name(name)
 *             .internal(true)
 *             .loadBalancerType("network")
 *             .subnets(subnetId)
 *             .build());
 *         var testVpcLink = new VpcLink("testVpcLink", VpcLinkArgs.builder()
 *             .name(name)
 *             .targetArn(test.arn())
 *             .build());
 *         var testRestApi = new RestApi("testRestApi", RestApiArgs.builder()
 *             .name(name)
 *             .build());
 *         var testResource = new Resource("testResource", ResourceArgs.builder()
 *             .restApi(testRestApi.id())
 *             .parentId(testRestApi.rootResourceId())
 *             .pathPart("test")
 *             .build());
 *         var testMethod = new Method("testMethod", MethodArgs.builder()
 *             .restApi(testRestApi.id())
 *             .resourceId(testResource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .requestModels(Map.of("application/json", "Error"))
 *             .build());
 *         var testIntegration = new Integration("testIntegration", IntegrationArgs.builder()
 *             .restApi(testRestApi.id())
 *             .resourceId(testResource.id())
 *             .httpMethod(testMethod.httpMethod())
 *             .requestTemplates(Map.ofEntries(
 *                 Map.entry("application/json", ""),
 *                 Map.entry("application/xml", """
 * #set($inputRoot = $input.path('$'))
 * { }                """)
 *             ))
 *             .requestParameters(Map.ofEntries(
 *                 Map.entry("integration.request.header.X-Authorization", "'static'"),
 *                 Map.entry("integration.request.header.X-Foo", "'Bar'")
 *             ))
 *             .type("HTTP")
 *             .uri("https://www.google.de")
 *             .integrationHttpMethod("GET")
 *             .passthroughBehavior("WHEN_NO_MATCH")
 *             .contentHandling("CONVERT_TO_TEXT")
 *             .connectionType("VPC_LINK")
 *             .connectionId(testVpcLink.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: dynamic
 *   subnetId:
 *     type: dynamic
 * resources:
 *   test:
 *     type: aws:lb:LoadBalancer
 *     properties:
 *       name: ${name}
 *       internal: true
 *       loadBalancerType: network
 *       subnets:
 *         - ${subnetId}
 *   testVpcLink:
 *     type: aws:apigateway:VpcLink
 *     name: test
 *     properties:
 *       name: ${name}
 *       targetArn: ${test.arn}
 *   testRestApi:
 *     type: aws:apigateway:RestApi
 *     name: test
 *     properties:
 *       name: ${name}
 *   testResource:
 *     type: aws:apigateway:Resource
 *     name: test
 *     properties:
 *       restApi: ${testRestApi.id}
 *       parentId: ${testRestApi.rootResourceId}
 *       pathPart: test
 *   testMethod:
 *     type: aws:apigateway:Method
 *     name: test
 *     properties:
 *       restApi: ${testRestApi.id}
 *       resourceId: ${testResource.id}
 *       httpMethod: GET
 *       authorization: NONE
 *       requestModels:
 *         application/json: Error
 *   testIntegration:
 *     type: aws:apigateway:Integration
 *     name: test
 *     properties:
 *       restApi: ${testRestApi.id}
 *       resourceId: ${testResource.id}
 *       httpMethod: ${testMethod.httpMethod}
 *       requestTemplates:
 *         application/json:
 *         application/xml: |-
 *           #set($inputRoot = $input.path('$'))
 *           { }
 *       requestParameters:
 *         integration.request.header.X-Authorization: '''static'''
 *         integration.request.header.X-Foo: '''Bar'''
 *       type: HTTP
 *       uri: https://www.google.de
 *       integrationHttpMethod: GET
 *       passthroughBehavior: WHEN_NO_MATCH
 *       contentHandling: CONVERT_TO_TEXT
 *       connectionType: VPC_LINK
 *       connectionId: ${testVpcLink.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_integration` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/integration:Integration example 12345abcde/67890fghij/GET
 * ```
 * */*/*/*/*/*/
 */
public class Integration internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Integration,
) : KotlinCustomResource(javaResource, IntegrationMapper) {
    /**
     * List of cache key parameters for the integration.
     */
    public val cacheKeyParameters: Output<List<String>>?
        get() = javaResource.cacheKeyParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Integration's cache namespace.
     */
    public val cacheNamespace: Output<String>
        get() = javaResource.cacheNamespace().applyValue({ args0 -> args0 })

    /**
     * ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
     */
    public val connectionId: Output<String>?
        get() = javaResource.connectionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
     */
    public val connectionType: Output<String>?
        get() = javaResource.connectionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
     */
    public val contentHandling: Output<String>?
        get() = javaResource.contentHandling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\*:user/\*`.
     */
    public val credentials: Output<String>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
     * when calling the associated resource.
     */
    public val httpMethod: Output<String>
        get() = javaResource.httpMethod().applyValue({ args0 -> args0 })

    /**
     * Integration HTTP method
     * (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
     * **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * Not all methods are compatible with all `AWS` integrations.
     * e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
     */
    public val integrationHttpMethod: Output<String>?
        get() = javaResource.integrationHttpMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
     */
    public val passthroughBehavior: Output<String>
        get() = javaResource.passthroughBehavior().applyValue({ args0 -> args0 })

    /**
     * Map of request query string parameters and headers that should be passed to the backend responder.
     * For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
     */
    public val requestParameters: Output<Map<String, String>>?
        get() = javaResource.requestParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Map of the integration's request templates.
     */
    public val requestTemplates: Output<Map<String, String>>?
        get() = javaResource.requestTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * API resource ID.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * ID of the associated REST API.
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
     */
    public val timeoutMilliseconds: Output<Int>?
        get() = javaResource.timeoutMilliseconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TLS configuration. See below.
     */
    public val tlsConfig: Output<IntegrationTlsConfig>?
        get() = javaResource.tlsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
     * For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
     * e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:012345678901:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
     */
    public val uri: Output<String>?
        get() = javaResource.uri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object IntegrationMapper : ResourceMapper<Integration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Integration::class == javaResource::class

    override fun map(javaResource: Resource): Integration = Integration(
        javaResource as
            com.pulumi.aws.apigateway.Integration,
    )
}

/**
 * @see [Integration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Integration].
 */
public suspend fun integration(name: String, block: suspend IntegrationResourceBuilder.() -> Unit): Integration {
    val builder = IntegrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Integration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integration(name: String): Integration {
    val builder = IntegrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
