@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Method].
 */
@PulumiTagMarker
public class MethodResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MethodArgs = MethodArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MethodArgsBuilder.() -> Unit) {
        val builder = MethodArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Method {
        val builtJavaResource = com.pulumi.aws.apigateway.Method(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Method(builtJavaResource)
    }
}

/**
 * Provides a HTTP Method for an API Gateway Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDemoAPI = new aws.apigateway.RestApi("MyDemoAPI", {
 *     name: "MyDemoAPI",
 *     description: "This is my API for demonstration purposes",
 * });
 * const myDemoResource = new aws.apigateway.Resource("MyDemoResource", {
 *     restApi: myDemoAPI.id,
 *     parentId: myDemoAPI.rootResourceId,
 *     pathPart: "mydemoresource",
 * });
 * const myDemoMethod = new aws.apigateway.Method("MyDemoMethod", {
 *     restApi: myDemoAPI.id,
 *     resourceId: myDemoResource.id,
 *     httpMethod: "GET",
 *     authorization: "NONE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
 *     name="MyDemoAPI",
 *     description="This is my API for demonstration purposes")
 * my_demo_resource = aws.apigateway.Resource("MyDemoResource",
 *     rest_api=my_demo_api.id,
 *     parent_id=my_demo_api.root_resource_id,
 *     path_part="mydemoresource")
 * my_demo_method = aws.apigateway.Method("MyDemoMethod",
 *     rest_api=my_demo_api.id,
 *     resource_id=my_demo_resource.id,
 *     http_method="GET",
 *     authorization="NONE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDemoAPI = new Aws.ApiGateway.RestApi("MyDemoAPI", new()
 *     {
 *         Name = "MyDemoAPI",
 *         Description = "This is my API for demonstration purposes",
 *     });
 *     var myDemoResource = new Aws.ApiGateway.Resource("MyDemoResource", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ParentId = myDemoAPI.RootResourceId,
 *         PathPart = "mydemoresource",
 *     });
 *     var myDemoMethod = new Aws.ApiGateway.Method("MyDemoMethod", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         ResourceId = myDemoResource.Id,
 *         HttpMethod = "GET",
 *         Authorization = "NONE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDemoAPI, err := apigateway.NewRestApi(ctx, "MyDemoAPI", &apigateway.RestApiArgs{
 * 			Name:        pulumi.String("MyDemoAPI"),
 * 			Description: pulumi.String("This is my API for demonstration purposes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myDemoResource, err := apigateway.NewResource(ctx, "MyDemoResource", &apigateway.ResourceArgs{
 * 			RestApi:  myDemoAPI.ID(),
 * 			ParentId: myDemoAPI.RootResourceId,
 * 			PathPart: pulumi.String("mydemoresource"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewMethod(ctx, "MyDemoMethod", &apigateway.MethodArgs{
 * 			RestApi:       myDemoAPI.ID(),
 * 			ResourceId:    myDemoResource.ID(),
 * 			HttpMethod:    pulumi.String("GET"),
 * 			Authorization: pulumi.String("NONE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *         var myDemoMethod = new Method("myDemoMethod", MethodArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDemoAPI:
 *     type: aws:apigateway:RestApi
 *     name: MyDemoAPI
 *     properties:
 *       name: MyDemoAPI
 *       description: This is my API for demonstration purposes
 *   myDemoResource:
 *     type: aws:apigateway:Resource
 *     name: MyDemoResource
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       parentId: ${myDemoAPI.rootResourceId}
 *       pathPart: mydemoresource
 *   myDemoMethod:
 *     type: aws:apigateway:Method
 *     name: MyDemoMethod
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       resourceId: ${myDemoResource.id}
 *       httpMethod: GET
 *       authorization: NONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Usage with Cognito User Pool Authorizer
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const config = new pulumi.Config();
 * const cognitoUserPoolName = config.requireObject("cognitoUserPoolName");
 * const this = aws.cognito.getUserPools({
 *     name: cognitoUserPoolName,
 * });
 * const thisRestApi = new aws.apigateway.RestApi("this", {name: "with-authorizer"});
 * const thisResource = new aws.apigateway.Resource("this", {
 *     restApi: thisRestApi.id,
 *     parentId: thisRestApi.rootResourceId,
 *     pathPart: "{proxy+}",
 * });
 * const thisAuthorizer = new aws.apigateway.Authorizer("this", {
 *     name: "CognitoUserPoolAuthorizer",
 *     type: "COGNITO_USER_POOLS",
 *     restApi: thisRestApi.id,
 *     providerArns: _this.then(_this => _this.arns),
 * });
 * const any = new aws.apigateway.Method("any", {
 *     restApi: thisRestApi.id,
 *     resourceId: thisResource.id,
 *     httpMethod: "ANY",
 *     authorization: "COGNITO_USER_POOLS",
 *     authorizerId: thisAuthorizer.id,
 *     requestParameters: {
 *         "method.request.path.proxy": true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * config = pulumi.Config()
 * cognito_user_pool_name = config.require_object("cognitoUserPoolName")
 * this = aws.cognito.get_user_pools(name=cognito_user_pool_name)
 * this_rest_api = aws.apigateway.RestApi("this", name="with-authorizer")
 * this_resource = aws.apigateway.Resource("this",
 *     rest_api=this_rest_api.id,
 *     parent_id=this_rest_api.root_resource_id,
 *     path_part="{proxy+}")
 * this_authorizer = aws.apigateway.Authorizer("this",
 *     name="CognitoUserPoolAuthorizer",
 *     type="COGNITO_USER_POOLS",
 *     rest_api=this_rest_api.id,
 *     provider_arns=this.arns)
 * any = aws.apigateway.Method("any",
 *     rest_api=this_rest_api.id,
 *     resource_id=this_resource.id,
 *     http_method="ANY",
 *     authorization="COGNITO_USER_POOLS",
 *     authorizer_id=this_authorizer.id,
 *     request_parameters={
 *         "method.request.path.proxy": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var cognitoUserPoolName = config.RequireObject<dynamic>("cognitoUserPoolName");
 *     var @this = Aws.Cognito.GetUserPools.Invoke(new()
 *     {
 *         Name = cognitoUserPoolName,
 *     });
 *     var thisRestApi = new Aws.ApiGateway.RestApi("this", new()
 *     {
 *         Name = "with-authorizer",
 *     });
 *     var thisResource = new Aws.ApiGateway.Resource("this", new()
 *     {
 *         RestApi = thisRestApi.Id,
 *         ParentId = thisRestApi.RootResourceId,
 *         PathPart = "{proxy+}",
 *     });
 *     var thisAuthorizer = new Aws.ApiGateway.Authorizer("this", new()
 *     {
 *         Name = "CognitoUserPoolAuthorizer",
 *         Type = "COGNITO_USER_POOLS",
 *         RestApi = thisRestApi.Id,
 *         ProviderArns = @this.Apply(@this => @this.Apply(getUserPoolsResult => getUserPoolsResult.Arns)),
 *     });
 *     var any = new Aws.ApiGateway.Method("any", new()
 *     {
 *         RestApi = thisRestApi.Id,
 *         ResourceId = thisResource.Id,
 *         HttpMethod = "ANY",
 *         Authorization = "COGNITO_USER_POOLS",
 *         AuthorizerId = thisAuthorizer.Id,
 *         RequestParameters =
 *         {
 *             { "method.request.path.proxy", true },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		cognitoUserPoolName := cfg.RequireObject("cognitoUserPoolName")
 * 		this, err := cognito.GetUserPools(ctx, &cognito.GetUserPoolsArgs{
 * 			Name: cognitoUserPoolName,
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisRestApi, err := apigateway.NewRestApi(ctx, "this", &apigateway.RestApiArgs{
 * 			Name: pulumi.String("with-authorizer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisResource, err := apigateway.NewResource(ctx, "this", &apigateway.ResourceArgs{
 * 			RestApi:  thisRestApi.ID(),
 * 			ParentId: thisRestApi.RootResourceId,
 * 			PathPart: pulumi.String("{proxy+}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisAuthorizer, err := apigateway.NewAuthorizer(ctx, "this", &apigateway.AuthorizerArgs{
 * 			Name:         pulumi.String("CognitoUserPoolAuthorizer"),
 * 			Type:         pulumi.String("COGNITO_USER_POOLS"),
 * 			RestApi:      thisRestApi.ID(),
 * 			ProviderArns: interface{}(this.Arns),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apigateway.NewMethod(ctx, "any", &apigateway.MethodArgs{
 * 			RestApi:       thisRestApi.ID(),
 * 			ResourceId:    thisResource.ID(),
 * 			HttpMethod:    pulumi.String("ANY"),
 * 			Authorization: pulumi.String("COGNITO_USER_POOLS"),
 * 			AuthorizerId:  thisAuthorizer.ID(),
 * 			RequestParameters: pulumi.BoolMap{
 * 				"method.request.path.proxy": pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.CognitoFunctions;
 * import com.pulumi.aws.cognito.inputs.GetUserPoolsArgs;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Authorizer;
 * import com.pulumi.aws.apigateway.AuthorizerArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var cognitoUserPoolName = config.get("cognitoUserPoolName");
 *         final var this = CognitoFunctions.getUserPools(GetUserPoolsArgs.builder()
 *             .name(cognitoUserPoolName)
 *             .build());
 *         var thisRestApi = new RestApi("thisRestApi", RestApiArgs.builder()
 *             .name("with-authorizer")
 *             .build());
 *         var thisResource = new Resource("thisResource", ResourceArgs.builder()
 *             .restApi(thisRestApi.id())
 *             .parentId(thisRestApi.rootResourceId())
 *             .pathPart("{proxy+}")
 *             .build());
 *         var thisAuthorizer = new Authorizer("thisAuthorizer", AuthorizerArgs.builder()
 *             .name("CognitoUserPoolAuthorizer")
 *             .type("COGNITO_USER_POOLS")
 *             .restApi(thisRestApi.id())
 *             .providerArns(this_.arns())
 *             .build());
 *         var any = new Method("any", MethodArgs.builder()
 *             .restApi(thisRestApi.id())
 *             .resourceId(thisResource.id())
 *             .httpMethod("ANY")
 *             .authorization("COGNITO_USER_POOLS")
 *             .authorizerId(thisAuthorizer.id())
 *             .requestParameters(Map.of("method.request.path.proxy", true))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   cognitoUserPoolName:
 *     type: dynamic
 * resources:
 *   thisRestApi:
 *     type: aws:apigateway:RestApi
 *     name: this
 *     properties:
 *       name: with-authorizer
 *   thisResource:
 *     type: aws:apigateway:Resource
 *     name: this
 *     properties:
 *       restApi: ${thisRestApi.id}
 *       parentId: ${thisRestApi.rootResourceId}
 *       pathPart: '{proxy+}'
 *   thisAuthorizer:
 *     type: aws:apigateway:Authorizer
 *     name: this
 *     properties:
 *       name: CognitoUserPoolAuthorizer
 *       type: COGNITO_USER_POOLS
 *       restApi: ${thisRestApi.id}
 *       providerArns: ${this.arns}
 *   any:
 *     type: aws:apigateway:Method
 *     properties:
 *       restApi: ${thisRestApi.id}
 *       resourceId: ${thisResource.id}
 *       httpMethod: ANY
 *       authorization: COGNITO_USER_POOLS
 *       authorizerId: ${thisAuthorizer.id}
 *       requestParameters:
 *         method.request.path.proxy: true
 * variables:
 *   this:
 *     fn::invoke:
 *       Function: aws:cognito:getUserPools
 *       Arguments:
 *         name: ${cognitoUserPoolName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_method` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/method:Method example 12345abcde/67890fghij/GET
 * ```
 */
public class Method internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Method,
) : KotlinCustomResource(javaResource, MethodMapper) {
    /**
     * Specify if the method requires an API key
     */
    public val apiKeyRequired: Output<Boolean>?
        get() = javaResource.apiKeyRequired().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of authorization used for the method (`NONE`, `CUSTOM`, `AWS_IAM`, `COGNITO_USER_POOLS`)
     */
    public val authorization: Output<String>
        get() = javaResource.authorization().applyValue({ args0 -> args0 })

    /**
     * Authorization scopes used when the authorization is `COGNITO_USER_POOLS`
     */
    public val authorizationScopes: Output<List<String>>?
        get() = javaResource.authorizationScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Authorizer id to be used when the authorization is `CUSTOM` or `COGNITO_USER_POOLS`
     */
    public val authorizerId: Output<String>?
        get() = javaResource.authorizerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     */
    public val httpMethod: Output<String>
        get() = javaResource.httpMethod().applyValue({ args0 -> args0 })

    /**
     * Function name that will be given to the method when generating an SDK through API Gateway. If omitted, API Gateway will generate a function name based on the resource path and HTTP verb.
     */
    public val operationName: Output<String>?
        get() = javaResource.operationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of the API models used for the request's content type
     * where key is the content type (e.g., `application/json`)
     * and value is either `Error`, `Empty` (built-in models) or `aws.apigateway.Model`'s `name`.
     */
    public val requestModels: Output<Map<String, String>>?
        get() = javaResource.requestModels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Map of request parameters (from the path, query string and headers) that should be passed to the integration. The boolean value indicates whether the parameter is required (`true`) or optional (`false`).
     * For example: `request_parameters = {"method.request.header.X-Some-Header" = true "method.request.querystring.some-query-param" = true}` would define that the header `X-Some-Header` and the query string `some-query-param` must be provided in the request.
     */
    public val requestParameters: Output<Map<String, Boolean>>?
        get() = javaResource.requestParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * ID of a `aws.apigateway.RequestValidator`
     */
    public val requestValidatorId: Output<String>?
        get() = javaResource.requestValidatorId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API resource ID
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })
}

public object MethodMapper : ResourceMapper<Method> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Method::class == javaResource::class

    override fun map(javaResource: Resource): Method = Method(
        javaResource as
            com.pulumi.aws.apigateway.Method,
    )
}

/**
 * @see [Method].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Method].
 */
public suspend fun method(name: String, block: suspend MethodResourceBuilder.() -> Unit): Method {
    val builder = MethodResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Method].
 * @param name The _unique_ name of the resulting resource.
 */
public fun method(name: String): Method {
    val builder = MethodResourceBuilder()
    builder.name(name)
    return builder.build()
}
