@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.MethodSettingsSettings
import com.pulumi.aws.apigateway.kotlin.outputs.MethodSettingsSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MethodSettings].
 */
@PulumiTagMarker
public class MethodSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MethodSettingsArgs = MethodSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MethodSettingsArgsBuilder.() -> Unit) {
        val builder = MethodSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MethodSettings {
        val builtJavaResource = com.pulumi.aws.apigateway.MethodSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MethodSettings(builtJavaResource)
    }
}

/**
 * Manages API Gateway Stage Method Settings. For example, CloudWatch logging and metrics.
 * > **NOTE:** We recommend using this resource in conjunction with the `aws.apigateway.Stage` resource instead of a stage managed by the `aws.apigateway.Deployment` resource optional `stage_name` argument. Stages managed by the `aws.apigateway.Deployment` resource are recreated on redeployment and this resource will require a second apply to recreate the method settings.
 * ## Example Usage
 * ### End-to-end
 * ### Off
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "OFF",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "OFF",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "OFF",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel: pulumi.String("OFF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("OFF")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: OFF
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Errors Only
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "ERROR",
 *         metricsEnabled: true,
 *         dataTraceEnabled: false,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "ERROR",
 *         "metrics_enabled": True,
 *         "data_trace_enabled": False,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "ERROR",
 *             MetricsEnabled = true,
 *             DataTraceEnabled = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel:     pulumi.String("ERROR"),
 * 				MetricsEnabled:   pulumi.Bool(true),
 * 				DataTraceEnabled: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("ERROR")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: ERROR
 *         metricsEnabled: true
 *         dataTraceEnabled: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Errors and Info Logs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "INFO",
 *         metricsEnabled: true,
 *         dataTraceEnabled: false,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "INFO",
 *         "metrics_enabled": True,
 *         "data_trace_enabled": False,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "INFO",
 *             MetricsEnabled = true,
 *             DataTraceEnabled = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel:     pulumi.String("INFO"),
 * 				MetricsEnabled:   pulumi.Bool(true),
 * 				DataTraceEnabled: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("INFO")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: INFO
 *         metricsEnabled: true
 *         dataTraceEnabled: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Full Request and Response Logs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "INFO",
 *         metricsEnabled: true,
 *         dataTraceEnabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "INFO",
 *         "metrics_enabled": True,
 *         "data_trace_enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "INFO",
 *             MetricsEnabled = true,
 *             DataTraceEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel:     pulumi.String("INFO"),
 * 				MetricsEnabled:   pulumi.Bool(true),
 * 				DataTraceEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("INFO")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: INFO
 *         metricsEnabled: true
 *         dataTraceEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_method_settings` using `REST-API-ID/STAGE-NAME/METHOD-PATH`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/methodSettings:MethodSettings example 12345abcde/example/test/GET
 * ```
 */
public class MethodSettings internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.MethodSettings,
) : KotlinCustomResource(javaResource, MethodSettingsMapper) {
    /**
     *  /*
     * Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
     */
    public val methodPath: Output<String>
        get() = javaResource.methodPath().applyValue({ args0 -> args0 })

    /**
     * ID of the REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Settings block, see below.
     */
    public val settings: Output<MethodSettingsSettings>
        get() = javaResource.settings().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Name of the stage
     */
    public val stageName: Output<String>
        get() = javaResource.stageName().applyValue({ args0 -> args0 })
}

public object MethodSettingsMapper : ResourceMapper<MethodSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.MethodSettings::class == javaResource::class

    override fun map(javaResource: Resource): MethodSettings = MethodSettings(
        javaResource as
            com.pulumi.aws.apigateway.MethodSettings,
    )
}

/**
 * @see [MethodSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MethodSettings].
 */
public suspend fun methodSettings(
    name: String,
    block: suspend MethodSettingsResourceBuilder.() -> Unit,
): MethodSettings {
    val builder = MethodSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MethodSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun methodSettings(name: String): MethodSettings {
    val builder = MethodSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
