@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.MethodSettingsArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.MethodSettingsSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.MethodSettingsSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *  /*
 * Manages API Gateway Stage Method Settings. For example, CloudWatch logging and metrics.
 * > **NOTE:** We recommend using this resource in conjunction with the `aws.apigateway.Stage` resource instead of a stage managed by the `aws.apigateway.Deployment` resource optional `stage_name` argument. Stages managed by the `aws.apigateway.Deployment` resource are recreated on redeployment and this resource will require a second apply to recreate the method settings.
 * ## Example Usage
 * ### End-to-end
 * ### Off
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "OFF",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "OFF",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "OFF",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel: pulumi.String("OFF"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("OFF")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: OFF
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Errors Only
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "ERROR",
 *         metricsEnabled: true,
 *         dataTraceEnabled: false,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "ERROR",
 *         "metrics_enabled": True,
 *         "data_trace_enabled": False,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "ERROR",
 *             MetricsEnabled = true,
 *             DataTraceEnabled = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel:     pulumi.String("ERROR"),
 * 				MetricsEnabled:   pulumi.Bool(true),
 * 				DataTraceEnabled: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("ERROR")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: ERROR
 *         metricsEnabled: true
 *         dataTraceEnabled: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Errors and Info Logs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "INFO",
 *         metricsEnabled: true,
 *         dataTraceEnabled: false,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "INFO",
 *         "metrics_enabled": True,
 *         "data_trace_enabled": False,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "INFO",
 *             MetricsEnabled = true,
 *             DataTraceEnabled = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel:     pulumi.String("INFO"),
 * 				MetricsEnabled:   pulumi.Bool(true),
 * 				DataTraceEnabled: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("INFO")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: INFO
 *         metricsEnabled: true
 *         dataTraceEnabled: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Full Request and Response Logs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const pathSpecific = new aws.apigateway.MethodSettings("path_specific", {
 *     restApi: example.id,
 *     stageName: exampleAwsApiGatewayStage.stageName,
 *     methodPath: "path1/GET",
 *     settings: {
 *         loggingLevel: "INFO",
 *         metricsEnabled: true,
 *         dataTraceEnabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * path_specific = aws.apigateway.MethodSettings("path_specific",
 *     rest_api=example["id"],
 *     stage_name=example_aws_api_gateway_stage["stageName"],
 *     method_path="path1/GET",
 *     settings={
 *         "logging_level": "INFO",
 *         "metrics_enabled": True,
 *         "data_trace_enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pathSpecific = new Aws.ApiGateway.MethodSettings("path_specific", new()
 *     {
 *         RestApi = example.Id,
 *         StageName = exampleAwsApiGatewayStage.StageName,
 *         MethodPath = "path1/GET",
 *         Settings = new Aws.ApiGateway.Inputs.MethodSettingsSettingsArgs
 *         {
 *             LoggingLevel = "INFO",
 *             MetricsEnabled = true,
 *             DataTraceEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apigateway.NewMethodSettings(ctx, "path_specific", &apigateway.MethodSettingsArgs{
 * 			RestApi:    pulumi.Any(example.Id),
 * 			StageName:  pulumi.Any(exampleAwsApiGatewayStage.StageName),
 * 			MethodPath: pulumi.String("path1/GET"),
 * 			Settings: &apigateway.MethodSettingsSettingsArgs{
 * 				LoggingLevel:     pulumi.String("INFO"),
 * 				MetricsEnabled:   pulumi.Bool(true),
 * 				DataTraceEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(example.id())
 *             .stageName(exampleAwsApiGatewayStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("INFO")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   pathSpecific:
 *     type: aws:apigateway:MethodSettings
 *     name: path_specific
 *     properties:
 *       restApi: ${example.id}
 *       stageName: ${exampleAwsApiGatewayStage.stageName}
 *       methodPath: path1/GET
 *       settings:
 *         loggingLevel: INFO
 *         metricsEnabled: true
 *         dataTraceEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_method_settings` using `REST-API-ID/STAGE-NAME/METHOD-PATH`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/methodSettings:MethodSettings example 12345abcde/example/test/GET
 * ```
 * @property methodPath Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
 * @property restApi ID of the REST API
 * @property settings Settings block, see below.
 * @property stageName Name of the stage
 */
public data class MethodSettingsArgs(
    public val methodPath: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val settings: Output<MethodSettingsSettingsArgs>? = null,
    public val stageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.MethodSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.MethodSettingsArgs =
        com.pulumi.aws.apigateway.MethodSettingsArgs.builder()
            .methodPath(methodPath?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stageName(stageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MethodSettingsArgs].
 */
@PulumiTagMarker
public class MethodSettingsArgsBuilder internal constructor() {
    private var methodPath: Output<String>? = null

    private var restApi: Output<String>? = null

    private var settings: Output<MethodSettingsSettingsArgs>? = null

    private var stageName: Output<String>? = null

    /**
     *  /*
     * @param value Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
     */
    @JvmName("kfngjlgbhydgxsps")
    public suspend fun methodPath(`value`: Output<String>) {
        this.methodPath = value
    }

    /**
     * @param value ID of the REST API
     */
    @JvmName("muvuxalmjrlpbxlr")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Settings block, see below.
     */
    @JvmName("ejxubqmexcroxuon")
    public suspend fun settings(`value`: Output<MethodSettingsSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("pokkabkiwjxdprsl")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     *  /*
     * @param value Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
     */
    @JvmName("vinfrgrapmaehkyq")
    public suspend fun methodPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methodPath = mapped
    }

    /**
     * @param value ID of the REST API
     */
    @JvmName("gghnsfyaqlaoifeh")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Settings block, see below.
     */
    @JvmName("fdnardvniwrrtqtm")
    public suspend fun settings(`value`: MethodSettingsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Settings block, see below.
     */
    @JvmName("dtfoyujtooaxasox")
    public suspend fun settings(argument: suspend MethodSettingsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MethodSettingsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("eljcjcvfweoqvyep")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): MethodSettingsArgs = MethodSettingsArgs(
        methodPath = methodPath,
        restApi = restApi,
        settings = settings,
        stageName = stageName,
    )
}
