@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Model].
 */
@PulumiTagMarker
public class ModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelArgs = ModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelArgsBuilder.() -> Unit) {
        val builder = ModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Model {
        val builtJavaResource = com.pulumi.aws.apigateway.Model(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Model(builtJavaResource)
    }
}

/**
 * Provides a Model for a REST API Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDemoAPI = new aws.apigateway.RestApi("MyDemoAPI", {
 *     name: "MyDemoAPI",
 *     description: "This is my API for demonstration purposes",
 * });
 * const myDemoModel = new aws.apigateway.Model("MyDemoModel", {
 *     restApi: myDemoAPI.id,
 *     name: "user",
 *     description: "a JSON schema",
 *     contentType: "application/json",
 *     schema: JSON.stringify({
 *         type: "object",
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
 *     name="MyDemoAPI",
 *     description="This is my API for demonstration purposes")
 * my_demo_model = aws.apigateway.Model("MyDemoModel",
 *     rest_api=my_demo_api.id,
 *     name="user",
 *     description="a JSON schema",
 *     content_type="application/json",
 *     schema=json.dumps({
 *         "type": "object",
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDemoAPI = new Aws.ApiGateway.RestApi("MyDemoAPI", new()
 *     {
 *         Name = "MyDemoAPI",
 *         Description = "This is my API for demonstration purposes",
 *     });
 *     var myDemoModel = new Aws.ApiGateway.Model("MyDemoModel", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         Name = "user",
 *         Description = "a JSON schema",
 *         ContentType = "application/json",
 *         Schema = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["type"] = "object",
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDemoAPI, err := apigateway.NewRestApi(ctx, "MyDemoAPI", &apigateway.RestApiArgs{
 * 			Name:        pulumi.String("MyDemoAPI"),
 * 			Description: pulumi.String("This is my API for demonstration purposes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"type": "object",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = apigateway.NewModel(ctx, "MyDemoModel", &apigateway.ModelArgs{
 * 			RestApi:     myDemoAPI.ID(),
 * 			Name:        pulumi.String("user"),
 * 			Description: pulumi.String("a JSON schema"),
 * 			ContentType: pulumi.String("application/json"),
 * 			Schema:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Model;
 * import com.pulumi.aws.apigateway.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoModel = new Model("myDemoModel", ModelArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .name("user")
 *             .description("a JSON schema")
 *             .contentType("application/json")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("type", "object")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDemoAPI:
 *     type: aws:apigateway:RestApi
 *     name: MyDemoAPI
 *     properties:
 *       name: MyDemoAPI
 *       description: This is my API for demonstration purposes
 *   myDemoModel:
 *     type: aws:apigateway:Model
 *     name: MyDemoModel
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       name: user
 *       description: a JSON schema
 *       contentType: application/json
 *       schema:
 *         fn::toJSON:
 *           type: object
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_model` using `REST-API-ID/NAME`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/model:Model example 12345abcde/example
 * ```
 */
public class Model internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Model,
) : KotlinCustomResource(javaResource, ModelMapper) {
    /**
     * Content type of the model
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Description of the model
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the model
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Schema of the model in a JSON form
     */
    public val schema: Output<String>?
        get() = javaResource.schema().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ModelMapper : ResourceMapper<Model> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Model::class == javaResource::class

    override fun map(javaResource: Resource): Model = Model(
        javaResource as
            com.pulumi.aws.apigateway.Model,
    )
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Model].
 */
public suspend fun model(name: String, block: suspend ModelResourceBuilder.() -> Unit): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 */
public fun model(name: String): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
