@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Model for a REST API Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myDemoAPI = new aws.apigateway.RestApi("MyDemoAPI", {
 *     name: "MyDemoAPI",
 *     description: "This is my API for demonstration purposes",
 * });
 * const myDemoModel = new aws.apigateway.Model("MyDemoModel", {
 *     restApi: myDemoAPI.id,
 *     name: "user",
 *     description: "a JSON schema",
 *     contentType: "application/json",
 *     schema: JSON.stringify({
 *         type: "object",
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
 *     name="MyDemoAPI",
 *     description="This is my API for demonstration purposes")
 * my_demo_model = aws.apigateway.Model("MyDemoModel",
 *     rest_api=my_demo_api.id,
 *     name="user",
 *     description="a JSON schema",
 *     content_type="application/json",
 *     schema=json.dumps({
 *         "type": "object",
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myDemoAPI = new Aws.ApiGateway.RestApi("MyDemoAPI", new()
 *     {
 *         Name = "MyDemoAPI",
 *         Description = "This is my API for demonstration purposes",
 *     });
 *     var myDemoModel = new Aws.ApiGateway.Model("MyDemoModel", new()
 *     {
 *         RestApi = myDemoAPI.Id,
 *         Name = "user",
 *         Description = "a JSON schema",
 *         ContentType = "application/json",
 *         Schema = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["type"] = "object",
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apigateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myDemoAPI, err := apigateway.NewRestApi(ctx, "MyDemoAPI", &apigateway.RestApiArgs{
 * 			Name:        pulumi.String("MyDemoAPI"),
 * 			Description: pulumi.String("This is my API for demonstration purposes"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"type": "object",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = apigateway.NewModel(ctx, "MyDemoModel", &apigateway.ModelArgs{
 * 			RestApi:     myDemoAPI.ID(),
 * 			Name:        pulumi.String("user"),
 * 			Description: pulumi.String("a JSON schema"),
 * 			ContentType: pulumi.String("application/json"),
 * 			Schema:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Model;
 * import com.pulumi.aws.apigateway.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .name("MyDemoAPI")
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoModel = new Model("myDemoModel", ModelArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .name("user")
 *             .description("a JSON schema")
 *             .contentType("application/json")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("type", "object")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myDemoAPI:
 *     type: aws:apigateway:RestApi
 *     name: MyDemoAPI
 *     properties:
 *       name: MyDemoAPI
 *       description: This is my API for demonstration purposes
 *   myDemoModel:
 *     type: aws:apigateway:Model
 *     name: MyDemoModel
 *     properties:
 *       restApi: ${myDemoAPI.id}
 *       name: user
 *       description: a JSON schema
 *       contentType: application/json
 *       schema:
 *         fn::toJSON:
 *           type: object
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_model` using `REST-API-ID/NAME`. For example:
 * ```sh
 * $ pulumi import aws:apigateway/model:Model example 12345abcde/example
 * ```
 * @property contentType Content type of the model
 * @property description Description of the model
 * @property name Name of the model
 * @property restApi ID of the associated REST API
 * @property schema Schema of the model in a JSON form
 */
public data class ModelArgs(
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val schema: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.ModelArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.ModelArgs =
        com.pulumi.aws.apigateway.ModelArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var restApi: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value Content type of the model
     */
    @JvmName("obacrdpxsbcgaspe")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Description of the model
     */
    @JvmName("pegjubkekrxsfsel")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the model
     */
    @JvmName("mhfnumfmfevxrott")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("japlwidvoienxryl")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Schema of the model in a JSON form
     */
    @JvmName("koakyrccwdakvniq")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value Content type of the model
     */
    @JvmName("figivokwilaroeae")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Description of the model
     */
    @JvmName("mdeleumpiaeqnjps")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the model
     */
    @JvmName("ybblxmqecqrhpmsf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("posrfhewknbbakwv")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Schema of the model in a JSON form
     */
    @JvmName("iyrvlibpadlofqfs")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        contentType = contentType,
        description = description,
        name = name,
        restApi = restApi,
        schema = schema,
    )
}
